#define _GNU_SOURCE
#define _XOPEN_SOURCE 600
#define _LARGEFILE64_SOURCE
#define _FILE_OFFSET_BITS 64

#include <errno.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
//#include <stdio.h>
//#include <sys/uio.h>

#include "../../include/org_maachang_util_nativeio_NativeIO.h"

// ファイルオープンパーミッション.
#define PERMISSION 0666

/** ファイルオープン. **/
JNIEXPORT jlong JNICALL Java_org_maachang_util_nativeio_NativeIO_open
  (JNIEnv* env, jclass c, jint mode, jint rw,jbyteArray bpath ) {
    int fp ;
    unsigned rwMode ;
    char* path = (*env)->GetPrimitiveArrayCritical(env, bpath, NULL);
    rwMode = ( rw == 0 ) ? O_RDONLY : ( ( rw == 1 ) ? O_WRONLY : O_RDWR ) ;
    fp = open64( path,
        ( rwMode | O_NOATIME | O_CREAT | O_LARGEFILE | O_SYNC ),
        PERMISSION ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, bpath, path, JNI_ABORT);
    if( fp <= -1 ) {
        return ( jlong )-1 ;
    }
    if( mode == 0 ) {
        // randomアクセスに特化.
        if( posix_fadvise64( fp, 0, 0, POSIX_FADV_RANDOM ) <= -1 ) {
            close( fp ) ;
            return -1 ;
        }
    }
    else {
        // シーケンスアクセスに特化.
        if( posix_fadvise64( fp, 0, 0, POSIX_FADV_SEQUENTIAL ) <= -1 ) {
            close( fp ) ;
            return -1 ;
        }
    }
    return ( jlong )fp ;
}

/** ファイルクローズ. **/
JNIEXPORT void JNICALL Java_org_maachang_util_nativeio_NativeIO_close
  (JNIEnv* env, jclass c, jlong h ) {
    if( h > -1 ) {
        close( h ) ;
    }
}

/** 読み込み処理. **/
JNIEXPORT jint JNICALL Java_org_maachang_util_nativeio_NativeIO_read
  (JNIEnv* env, jclass c, jlong h, jlong seek, jbyteArray out, jint off, jint len) {
    int ret ;
    char* data = (*env)->GetPrimitiveArrayCritical(env, out, NULL);
    if( seek <= -1 ) {
        ret = read( h,( char* )data+off,len ) ;
    }
    else {
        ret = pread64( h,( char* )data+off,len,seek ) ;
    }
    (*env)->ReleasePrimitiveArrayCritical(env, out, data, JNI_ABORT);
    if( ret <= -1 ) {
        return ( jint )-1 ;
    }
    return ( jint )ret ;
}

/** 書込み処理 **/
JNIEXPORT jint JNICALL Java_org_maachang_util_nativeio_NativeIO_write
  (JNIEnv* env, jclass c, jlong h, jlong seek, jbyteArray in, jint off, jint len) {
    int ret ;
    char* data = (*env)->GetPrimitiveArrayCritical(env, in, NULL);
    if( seek <= -1 ) {
        ret = write( h,( char* )data+off,len ) ;
    }
    else {
        ret = pwrite64( h,( char* )data+off,len,seek ) ;
    }
    (*env)->ReleasePrimitiveArrayCritical(env, in, data, JNI_ABORT);
    if( ret <= -1 ) {
        return ( jint )-1 ;
    }
    return ( jint )ret ;
}

/** ファイルサイズを取得 **/
JNIEXPORT jlong JNICALL Java_org_maachang_util_nativeio_NativeIO_getLength
  (JNIEnv* env, jclass c, jlong h ) {
    struct stat64 buf64;
    int ret;
    ret = fstat64( h,&buf64 );
    if( ret >= 0 ) {
        return buf64.st_size ;
    }
    return (jlong)-1 ;
}

/** ファイルサイズを設定 **/
JNIEXPORT jint JNICALL Java_org_maachang_util_nativeio_NativeIO_setLength
  (JNIEnv* env, jclass c, jlong h , jlong len ) {
    int ret = 0 ;
    return ftruncate64( h,len ) ;
}

