package org.maachang.util;

/**
 * 文字列チェック処理.
 * 
 * @version 2008/10/30
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public abstract class IsString {
    
    /**
     * IPアドレス(V4)チェック.
     * @param value チェック対象のデータを設定します.
     * @return boolean [true]の場合、条件が当てはまりません.
     */
    public static final boolean isIpAddress( String value ) {
        return StringUtil.isMatch( "/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$/",value ) ;
    }
    
    /**
     * URLチェック.
     * @param value チェック対象のデータを設定します.
     * @return boolean [true]の場合、条件が当てはまりません.
     */
    public static final boolean isUrl( String value ) {
        return StringUtil.isMatch( "/^(((ht|f)tp(s?))\\:\\/\\/)([0-9a-zA-Z\\-]+\\.)+[a-zA-Z]{2,6}(\\:[0-9]+)?(\\/\\S*)?$/",value ) ;
    }
    
    /**
     * メールアドレスチェック.
     * @param value チェック対象のデータを設定します.
     * @return boolean [true]の場合、条件が当てはまりません.
     */
    public static final boolean isMailAddress( String value ) {
        return StringUtil.isMatch( "/^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*(\\.([a-z]){2,4})$/",value ) ;
    }
    
}
