package org.maachang.util;

/**
 * オブジェクトリスト定義.
 * 
 * @version 2008/12/11
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public interface OList {
    /**
     * 配列縮小係数.
     */
    public static final double REDUCTION_ARRAY = 0.375;
    
    /**
     * 開始時配列管理数 : デフォルト.
     */
    public static final int DEFAULT_START_LENGTH = 8;
    
    /**
     * 開始時配列管理数 : 最大値.
     */
    public static final int MAX_START_LENGTH = Integer.MAX_VALUE;
    
    /**
     * 開始時配列管理数 : 最小値.
     */
    public static final int MIN_START_LENGTH = 2;
    
    /**
     * 情報クリア. <BR>
     * <BR>
     * 対象の情報をクリアします.
     */
    public void clear() ;
    
    /**
     * 情報追加. <BR>
     * <BR>
     * 対象の情報を追加します. <BR>
     * 
     * @param value
     *            設定対象のオブジェクト情報を追加します.
     */
    public void add(Object value) ;
    
    /**
     * 情報設定. <BR>
     * <BR>
     * 対象の位置に情報をセットします. <BR>
     * 
     * @param no
     *            設定対象項番を設定します.
     * @param value
     *            設定対象情報を設定します.
     */
    public void set(int no, Object value) ;
    
    /**
     * 情報削除. <BR>
     * <BR>
     * 対象の情報を削除します. <BR>
     * 
     * @param no
     *            削除対象の項番を設定します.
     * @return Object 削除されたオブジェクト情報が返されます.<BR>
     *         情報が存在しない場合[null]が返されます.
     */
    public Object remove(int no) ;
    
    /**
     * 情報取得. <BR>
     * <BR>
     * 対象の情報を取得します. <BR>
     * 
     * @param no
     *            取得対象の項番を設定します.
     * @return Object 取得された情報が返されます.<BR>
     *         情報が存在しない場合[null]が返されます.
     */
    public Object get(int no) ;
    
    /**
     * 格納情報数の取得. <BR>
     * <BR>
     * 格納されている情報数を取得します. <BR>
     * 
     * @return int 格納されている情報数が返されます.
     */
    public int size() ;
}
