package org.maachang.util;

import org.maachang.util.atomic.AtomicXor128Random;



/**
 * ランダムユーティリティ.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class RandomUtil {    
    /**
     * 乱数オブジェクト.
     */
    private static final AtomicXor128Random RAND = new AtomicXor128Random() ;

    /**
     * ランダムシートの設定. <BR>
     * <BR>
     * 新たにランダム用のシート情報を設定します.
     */
    public static final void randomize() {
        RAND.setSeed( System.nanoTime() ) ;
    }

    /**
     * ランダムな値を取得. <BR>
     * <BR>
     * ランダムな値を取得します. <BR>
     * 
     * @param max
     *            ランダム値の最大番号を指定します。
     * @return int 上記指定した情報のランダム値を取得します。
     */
    public static final int random() {
        return (int) RAND.nextInt() ;
    }

    /**
     * ランダムな値を取得. <BR>
     * <BR>
     * ランダムな値を取得します. <BR>
     * 
     * @param max
     *            ランダム値の最大番号を指定します。
     * @return int 上記指定した情報のランダム値を取得します。
     */
    public static final int random(int max) {
        return (int) RAND.nextInt(max) ;
    }

    /**
     * ランダムな値をバイナリで取得. <BR>
     * <BR>
     * ランダムな値をバイナリで取得します. <BR>
     * 
     * @param out
     *            ランダム値を格納するバイナリ情報を設定します.
     * @exception IllegalArgumentException
     *                入力例外.
     */
    public static final void randomBinary(byte[] out)
            throws IllegalArgumentException {
        if (out == null) {
            throw new IllegalArgumentException("引数は不正です");
        }
        RAND.nextBytes(out);
    }

    /**
     * ランダムな値をバイナリで取得. <BR>
     * <BR>
     * ランダムな値をバイナリで取得します. <BR>
     * 
     * @param length
     *            生成対象のバイナリ情報長を設定します.
     * @return byte[] ランダム値が格納されたバイナリ情報が返されます.
     * @exception IllegalArgumentException
     *                入力例外.
     */
    public static final byte[] randomBinary(int length)
            throws IllegalArgumentException {
        byte[] ret = null;
        if (length <= 0) {
            throw new IllegalArgumentException("引数は不正です");
        }
        ret = new byte[length];
        RAND.nextBytes(ret);
        return ret ;
    }

    /**
     * ランダムな文字列を取得. <BR>
     * <BR>
     * ランダムな文字列を取得します. <BR>
     * 
     * @param size
     *            ランダムに設定する文字数を指定します.
     * @param number
     *            数字を許可するか指定します.
     * @param half
     *            半角文字を許可するか指定します.
     * @param full
     *            全角文字を許可するか指定します.
     * @return String 上記指定された内容のランダムな文字列が返されます.
     */
    public static final String randomString(int size, boolean number,
            boolean half, boolean full) {
        if (size <= 0 || (number == false && half == false && full == false)) {
            if (number == false && half == false && full == false) {
                number = true;
            } else {
                return null;
            }
        }
        RRV_RandTo[] check = new RRV_RandTo[3];
        int randSize = 0;
        if (number == true) {
            check[randSize] = RandomString.prv_num;
            randSize += 1;
        }
        if (half == true) {
            check[randSize] = RandomString.prv_half;
            randSize += 1;
        }
        if (full == true) {
            check[randSize] = RandomString.prv_full;
            randSize += 1;
        }
        StringBuilder buf = new StringBuilder(size);
        for (int i = 0; i < size; i++) {
            buf.append( check[random( randSize )].create( RAND ) ) ;
        }
        return buf.toString() ;
    }
}
