package org.maachang.util ;

import java.io.InputStream;

/**
 * コマンド実行処理.
 * 
 * @version 2008/11/01
 * @author masahito suzuki
 * @since MaachangBase 1.08
 */
public class RunProcess {
    
    /**
     * 実行コマンド.
     */
    private String[] cmd = null ;
    
    /**
     * 実行プロセス.
     */
    private Process process = null ;
    
    /**
     * コンストラクタ.
     */
    private RunProcess() {
        
    }
    
    /**
     * コンストラクタ.
     * @param cmd 実行コマンドを設定します.
     */
    public RunProcess( String[] cmd ) {
        if( cmd == null || cmd.length <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.cmd = cmd ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    public void destroy() {
        if( process != null ) {
            try {
                process.getInputStream().close() ;
            } catch( Exception e ) {
            }
            try {
                process.getOutputStream().close() ;
            } catch( Exception e ) {
            }
            try {
                process.getErrorStream().close() ;
            } catch( Exception e ) {
            }
        }
        cmd = null ;
        process = null ;
    }
    
    /**
     * コマンド実行.
     * @exception Exception 例外.
     */
    public InputStream execution() throws Exception {
        if( cmd == null || cmd.length <= 0 ) {
            throw new IllegalArgumentException( "コマンドが設定されていません" ) ;
        }
        try {
            this.process = Runtime.getRuntime().exec(cmd) ;
        } catch( Exception e ) {
            destroy() ;
            throw e ;
        }
        return this.process.getInputStream() ;
    }
    
    /**
     * コマンド終了まで、待機.
     * @return int 終了コマンドコードが返されます.
     * @exception Exception 例外.
     */
    public int waitFor() throws Exception {
        if( this.process != null ) {
            return this.process.waitFor() ;
        }
        return -1 ;
    }
}
