package org.maachang.util;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * バッファキュー.
 * 
 * @version 2008/10/24
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class SimpleQueue<T> {
    
    /** キュー管理 */
    private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue<T>() ;
    
    /**
     * コンストラクタ.
     */
    public SimpleQueue() {
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    public void destroy() {
        queue.clear() ;
    }
    
    /**
     * データ追加.
     * @param value 追加対象のデータを設定します.
     */
    public void add( T value ) {
        if( value != null ) {
            queue.offer( value ) ;
        }
    }
    
    /**
     * データ取得.
     * @return T 格納されているデータが返されます.
     */
    public T get() {
        return queue.poll() ;
    }
    
    /**
     * 格納数取得.
     * @return int 格納数が返されます.
     */
    public int size() {
        return queue.size() ;
    }
}
