package org.maachang.util.atomic ;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;

/**
 * Atomic配列.
 * 
 * @version 2008/12/01
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicARRAY<T> implements Serializable {
    private static final long serialVersionUID = -70907164927496290L;
    private AtomicReferenceArray<T> ato = null ;
    private int size = -1 ;
    
    /**
     * コンストラクタ.
     */
    private AtomicARRAY() {
        
    }
    
    /**
     * コンストラクタ.
     * @param size 対象のサイズを設定します.
     */
    public AtomicARRAY( int size ) {
        if( size <= 0 ) {
            throw new IllegalArgumentException( "配列数が不正です" ) ;
        }
        ato = new AtomicReferenceArray<T>( size ) ;
        this.size = size ;
    }
    
    /**
     * Object値を取得.
     * @param no 対象の項番を設定します.
     * @return T Object値が返されます.
     */
    public T get( int no ) {
        if( no < 0 || no >= size ) {
            throw new IllegalArgumentException( "指定範囲は不正です" ) ;
        }
        return ato.get( no ) ;
    }
    
    /**
     * Objectを設定.
     * @param t 対象オブジェクトを設定します.
     * @param no 対象の項番を設定します.
     */
    public void set( T t,int no ) {
        if( no < 0 || no >= size ) {
            throw new IllegalArgumentException( "指定範囲は不正です" ) ;
        }
        setting( t,no ) ;
    }
    
    /**
     * サイズを取得.
     * @return int サイズが返されます.
     */
    public int size() {
        return ato.length() ;
    }
    
    private void setting( T t,int no ) {
        while( true ) {
            if( ato.compareAndSet( no,ato.get( no ),t ) ) {
                break ;
            }
        }
    }
}
