package org.maachang.util.atomic ;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * AtomicBOOL.
 * 
 * @version 2008/12/01
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicBOOL implements Serializable,AtomicPrimitive {
    private static final long serialVersionUID = 8706524839458406391L;
    private final AtomicInteger ato = new AtomicInteger( 0 ) ;
    
    /**
     * コンストラクタ.
     */
    public AtomicBOOL() {
        
    }
    
    /**
     * コンストラクタ.
     * @param f 初期値を設定します.
     */
    public AtomicBOOL( boolean f ) {
        setting( ( f ) ? 1 : 0 ) ;
    }
    
    /**
     * コンストラクタ.
     * @param f 初期値を設定します.
     */
    public AtomicBOOL( Boolean f ) {
        if( f != null ) {
            setting( ( f.booleanValue() ) ? 1 : 0 ) ;
        }
    }
    
    /**
     * Boolean値を取得.
     * @return boolean Boolean値が返されます.
     */
    public boolean get() {
        return ato.get() != 0 ;
    }
    
    /**
     * Boolean値を取得.
     * @return boolean Boolean値が返されます.
     */
    public Boolean getObject() {
        return new Boolean( ato.get() != 0 ) ;
    }
    
    /**
     * Boolean値を設定.
     * @param f Boolean値を設定します.
     */
    public void set( boolean f ) {
        setting( ( f ) ? 1 : 0 ) ;
    }
    
    /**
     * Boolean値を設定.
     * @param f Boolean値を設定します.
     */
    public void set( Boolean f ) {
        if( f != null ) {
            setting( ( f.booleanValue() ) ? 1 : 0 ) ;
        }
    }
    
    /**
     * 文字列変換.
     * @return String 文字列が返されます.
     */
    public String toString() {
        return String.valueOf( get() ) ;
    }
    
    /**
     * オブジェクトを取得.
     * @return Object オブジェクトが返されます.
     */
    public Object base() {
        return ato ;
    }
    
    /**
     * オブジェクトタイプを取得.
     * @return int java.sql.Typesの各条件が返されます.
     */
    public int getType() {
        return java.sql.Types.BOOLEAN ;
    }
    
    private void setting( int no ) {
        while( true ) {
            if( ato.compareAndSet( ato.get(),no ) ) {
                break ;
            }
        }
    }
}
