package org.maachang.util.atomic ;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

/**
 * AtomicDouble.
 * 
 * @version 2008/12/01
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicDOUBLE implements Serializable,AtomicPrimitive {
    private static final long serialVersionUID = 4491352238973168818L;
    private final AtomicLong ato = new AtomicLong( 0L ) ;
    
    /**
     * コンストラクタ.
     */
    public AtomicDOUBLE() {
        
    }
    
    /**
     * コンストラクタ.
     * @param n 初期値を設定します.
     */
    public AtomicDOUBLE( double n ) {
        setting( Double.doubleToLongBits( n ) ) ;
    }
    
    /**
     * コンストラクタ.
     * @param n 初期値を設定します.
     */
    public AtomicDOUBLE( Double n ) {
        if( n != null ) {
            setting( Double.doubleToLongBits( n.doubleValue() ) ) ;
        }
    }
    
    /**
     * double値を取得.
     * @return double double値が返されます.
     */
    public double get() {
        return Double.longBitsToDouble( ato.get() ) ;
    }
    
    /**
     * Double値を取得.
     * @return Double Double値が返されます.
     */
    public Double getObject() {
        return new Double( get() ) ;
    }
    
    /**
     * double値を設定.
     * @param n double値を設定します.
     */
    public void set( double n ) {
        setting( Double.doubleToLongBits( n ) ) ;
    }
    
    /**
     * Double値を設定.
     * @param n Double値を設定します.
     */
    public void set( Double n ) {
        if( n != null ) {
            setting( Double.doubleToLongBits( n.doubleValue() ) ) ;
        }
    }
    
    /**
     * 指定数の足し算.
     * @param no 対象の数値を設定します.
     * @return double 結果内容が返されます.
     */
    public double add( double no ) {
        long n ;
        long r ;
        while( true ) {
            n = ato.get() ;
            r = Double.doubleToLongBits( Double.longBitsToDouble( n ) + no ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Double.longBitsToDouble( r ) ;
            }
        }
    }
    
    /**
     * 指定数の足し算.
     * @param no 対象の数値を設定します.
     * @return double 結果内容が返されます.
     */
    public double add( Double no ) {
        if( no == null ) {
            return -1d ;
        }
        long n ;
        long r ;
        double x = no.doubleValue() ;
        while( true ) {
            n = ato.get() ;
            r = Double.doubleToLongBits( Double.longBitsToDouble( n ) + x ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Double.longBitsToDouble( r ) ;
            }
        }
    }
    
    /**
     * 指定数の引き算.
     * @param no 対象の数値を設定します.
     * @return double 結果内容が返されます.
     */
    public double remove( double no ) {
        long n ;
        long r ;
        while( true ) {
            n = ato.get() ;
            r = Double.doubleToLongBits( Double.longBitsToDouble( n ) - no ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Double.longBitsToDouble( r ) ;
            }
        }
    }
    
    /**
     * 指定数の引き算.
     * @param no 対象の数値を設定します.
     * @return double 結果内容が返されます.
     */
    public double remove( Double no ) {
        if( no == null ) {
            return -1d ;
        }
        long n ;
        long r ;
        double x = no.doubleValue() ;
        while( true ) {
            n = ato.get() ;
            r = Double.doubleToLongBits( Double.longBitsToDouble( n ) - x ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Double.longBitsToDouble( r ) ;
            }
        }
    }
    
    /**
     * 1インクリメント.
     * @return double 結果内容が返されます.
     */
    public double inc() {
        long n ;
        long r ;
        while( true ) {
            n = ato.get() ;
            r = Double.doubleToLongBits( Double.longBitsToDouble( n ) + 1.0f ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Double.longBitsToDouble( r ) ;
            }
        }
    }
    
    /**
     * 1デクリメント.
     * @return double 結果内容が返されます.
     */
    public double dec() {
        long n ;
        long r ;
        while( true ) {
            n = ato.get() ;
            r = Double.doubleToLongBits( Double.longBitsToDouble( n ) - 1.0f ) ;
            if( ato.compareAndSet( n,r ) ) {
                return Double.longBitsToDouble( r ) ;
            }
        }
    }
    
    /**
     * 文字列変換.
     * @return String 文字列が返されます.
     */
    public String toString() {
        return String.valueOf( get() ) ;
    }
    
    /**
     * オブジェクトを取得.
     * @return Object オブジェクトが返されます.
     */
    public Object base() {
        return ato ;
    }
    
    /**
     * オブジェクトタイプを取得.
     * @return int java.sql.Typesの各条件が返されます.
     */
    public int getType() {
        return java.sql.Types.DOUBLE ;
    }
    
    private void setting( long no ) {
        while( true ) {
            if( ato.compareAndSet( ato.get(),no ) ) {
                break ;
            }
        }
    }
}
