package org.maachang.util.atomic;

import org.maachang.util.AbstractBaseRandom;
import org.maachang.util.BaseRandom;

/**
 * [Atomic]drand48-ランダム処理.
 * 
 * @version 2008/12/11
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicDrand48Random extends AbstractBaseRandom implements BaseRandom {
    private static final long serialVersionUID = 907130768057232988L;
    private static final long MASK = 0x0000ffffffffffffL ;
    private static final AtomicLONG seedUniquifier = new AtomicLONG( 8682522807148012L );
    private final AtomicLONG s = new AtomicLONG( 0x1234ABCD330EL ) ;
    
    /** nano時間セット. **/
    private long nano8bit() {
        return ( System.nanoTime() & 0x00000000000000ffL ) ;
    }
    
    /**
     * コンストラクタ.
     */
    public AtomicDrand48Random() {
        this( seedUniquifier.inc() ) ;
    }
    
    /**
     * コンストラクタ.
     * @param seed 乱数初期係数を設定します.
     */
    public AtomicDrand48Random( long seed ) {
        this.setSeed( seed ) ;
    }
    
    /**
     * ランダム係数を設定.
     * @param seed ランダム係数を設定します.
     */
    public final void setSeed(long seed) {
        seed = ( seed * nano8bit() ) & MASK ;
        s.set( ( (seed<<16L)+0x330EL ) & MASK ) ;
    }
    
    /**
     * 32ビット乱数を取得.
     * @return int 32ビット乱数が返されます.
     */
    public final int nextInt() {
        long x = s.get() ;
        x = ((x*0x00000005DEECE66DL) + 0x000000000000000BL) & MASK;
        s.set( x ) ;
        return (int)(x>>16L);
    }
}

