package org.maachang.util.atomic ;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * AtomicINT.
 * 
 * @version 2008/12/01
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicINT implements Serializable,AtomicPrimitive {
    private static final long serialVersionUID = 2146413862872622803L;
    private final AtomicInteger ato = new AtomicInteger( 0 ) ;
    
    /**
     * コンストラクタ.
     */
    public AtomicINT() {
        
    }
    
    /**
     * コンストラクタ.
     * @param n 初期値を設定します.
     */
    public AtomicINT( int n ) {
        setting( n ) ;
    }
    
    /**
     * コンストラクタ.
     * @param n 初期値を設定します.
     */
    public AtomicINT( Integer n ) {
        if( n != null ) {
            setting( n.intValue() ) ;
        }
    }
    
    /**
     * int値を取得.
     * @return int int値が返されます.
     */
    public int get() {
        return ato.get() ;
    }
    
    /**
     * Integer値を取得.
     * @return Integer Integer値が返されます.
     */
    public Integer getObject() {
        return new Integer( ato.get() ) ;
    }
    
    /**
     * int値を設定.
     * @param n int値を設定します.
     */
    public void set( int n ) {
        setting( n ) ;
    }
    
    /**
     * Integer値を設定.
     * @param n Integer値を設定します.
     */
    public void set( Integer n ) {
        if( n != null ) {
            setting( n.intValue() ) ;
        }
    }
    
    /**
     * 指定数の足し算.
     * @param no 対象の数値を設定します.
     * @return int 結果内容が返されます.
     */
    public int add( int no ) {
        int n ;
        int r ;
        while( true ) {
            n = ato.get() ;
            r = n + no ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 指定数の足し算.
     * @param no 対象の数値を設定します.
     * @return int 結果内容が返されます.
     */
    public int add( Integer no ) {
        if( no == null ) {
            return -1 ;
        }
        int n ;
        int r ;
        int x = no.intValue() ;
        while( true ) {
            n = ato.get() ;
            r = n + x ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 指定数の引き算.
     * @param no 対象の数値を設定します.
     * @return int 結果内容が返されます.
     */
    public int remove( int no ) {
        int n ;
        int r ;
        while( true ) {
            n = ato.get() ;
            r = n - no ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 指定数の引き算.
     * @param no 対象の数値を設定します.
     * @return int 結果内容が返されます.
     */
    public int remove( Integer no ) {
        if( no == null ) {
            return -1 ;
        }
        int n ;
        int r ;
        int x = no.intValue() ;
        while( true ) {
            n = ato.get() ;
            r = n - x ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 1インクリメント.
     * @return int 結果内容が返されます.
     */
    public int inc() {
        int n ;
        int r ;
        while( true ) {
            n = ato.get() ;
            r = n + 1 ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 1デクリメント.
     * @return int 結果内容が返されます.
     */
    public int dec() {
        int n ;
        int r ;
        while( true ) {
            n = ato.get() ;
            r = n - 1 ;
            if( ato.compareAndSet( n,r ) ) {
                return r ;
            }
        }
    }
    
    /**
     * 文字列変換.
     * @return String 文字列が返されます.
     */
    public String toString() {
        return String.valueOf( get() ) ;
    }
    
    /**
     * オブジェクトを取得.
     * @return Object オブジェクトが返されます.
     */
    public Object base() {
        return ato ;
    }
    
    /**
     * オブジェクトタイプを取得.
     * @return int java.sql.Typesの各条件が返されます.
     */
    public int getType() {
        return java.sql.Types.INTEGER ;
    }
    
    private void setting( int no ) {
        while( true ) {
            if( ato.compareAndSet( ato.get(),no ) ) {
                break ;
            }
        }
    }
}
