package org.maachang.util.atomic;

import java.util.concurrent.atomic.AtomicInteger;

import org.maachang.util.AbstractBaseRandom;
import org.maachang.util.BaseRandom;

/**
 * [Atomic]xor128ランダム処理.
 * 
 * @version 2008/12/11
 * @author masahito suzuki
 * @since MaachangBase 1.09
 */
public class AtomicXor128Random extends AbstractBaseRandom implements BaseRandom {
    private static final long serialVersionUID = 4646272181287409322L;
    private static final AtomicLONG seedUniquifier = new AtomicLONG( 8682522807148012L );
    private final AtomicInteger ax = new AtomicInteger( 123456789 ) ;
    private final AtomicInteger ay = new AtomicInteger( 362436069 ) ;
    private final AtomicInteger az = new AtomicInteger( 521288629 ) ;
    private final AtomicInteger aw = new AtomicInteger( 88675123 ) ;
    
    /** nano時間セット. **/
    private long nano8bit() {
        return ( System.nanoTime() & 0x00000000000000ffL ) ;
    }
    
    /**
     * コンストラクタ.
     */
    public AtomicXor128Random() {
        this( seedUniquifier.inc() ) ;
    }
    
    /**
     * コンストラクタ.
     * @param seed 乱数初期係数を設定します.
     */
    public AtomicXor128Random( long seed ) {
        this.setSeed( seed ) ;
    }
    
    /**
     * ランダム係数を設定.
     * @param seed ランダム係数を設定します.
     */
    public final void setSeed(long seed) {
        seed = ( seed * nano8bit() ) & 0x00ffffffffffffffL ;
        aw.set( (int)( seed & 0x00000000ffffffffL ) ) ;
        nextInt() ;
        aw.set( ( aw.get() ^ (int)( ( seed & 0xffffffff00000000L ) >> 32L ) ) ) ;
        nextInt() ;
    }
    
    /**
     * 32ビット乱数を取得.
     * @return int 32ビット乱数が返されます.
     */
    public final int nextInt() {
        int t,r,x,y,z,w ;
        x = ax.get() ;y = ay.get() ;z = az.get() ;w = aw.get() ;
        t=x; r=t; t<<=11; t^=r; r=t; r>>=8; t^=r; r=y;x=r;
        r=z;y=r; r=w; z=r; t^=r; r>>=19; r^=t; w=r;
        ax.compareAndSet( ax.get(),x ) ;
        ay.compareAndSet( ay.get(),y ) ;
        az.compareAndSet( az.get(),z ) ;
        aw.compareAndSet( aw.get(),w ) ;
        return w;
    }
    
}

