package org.maachang.util.nativeio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.maachang.util.Os;
import org.maachang.util.atomic.AtomicBOOL;

/**
 * NativeI/O.
 * 
 * @version 2008/11/29
 * @author  masahito suzuki
 * @since   MaachangBase-1.09
 */
class NativeIO {
    private static final AtomicBOOL initFlag = new AtomicBOOL( false ) ;
    static {
        String name = NativeIODefine.LIB_NAME ;
        String lib = name + "-" + NativeIODefine.VERSION ;
        switch( Os.getInstance().getOS() ) {
            case Os.OS_WINNT :
                lib += NativeIODefine.WINDOWS_LIB_PLUS ;
                System.load( targetDynamincLib( true,lib ) ) ;
                initFlag.set( true ) ;
                break ;
            case Os.OS_UNIX :
                lib += NativeIODefine.LINUX_LIB_PLUS ;
                System.load( targetDynamincLib( true,lib ) ) ;
                initFlag.set( true ) ;
                break ;
            default :
                initFlag.set( false ) ;
                break ;
        }
    }
    
    private static final String targetDynamincLib( boolean mode,String lib ) {
        String sp = System.getProperty( "file.separator" ) ;
        File targetDir = null ;
        targetDir = new File( new StringBuilder().
            append( System.getProperty( "user.home" ) ).
            append( sp ).
            append( NativeIODefine.DEFAULT_DIR ).
            toString() );
        if( targetDir.exists() == false ) {
            targetDir.mkdirs() ;
        }
        File outFile = new File( targetDir,lib );
        if( mode == true ) {
            String ntvDir = NativeIODefine.NATIVE_PACKAGE ;
            ntvDir = ntvDir.trim() ;
            if( ntvDir.endsWith( "/" ) == false ) {
                ntvDir += "/" ;
            }
            if( ntvDir.startsWith( "/" ) ) {
                ntvDir = ntvDir.substring( 1 ) ;
            }
            InputStream is = new BufferedInputStream(
                Thread.currentThread().getContextClassLoader().getResourceAsStream(
                    ntvDir + lib ) ) ;
            if( isLibFile( outFile,is ) ) {
                try{
                    OutputStream os = new BufferedOutputStream( new FileOutputStream( outFile ) ) ;
                    try{
                        try{
                            for(;;) {
                                int n = is.read();
                                if( n <= -1 ) {
                                    break;
                                }
                                os.write( n );
                            }
                            os.flush() ;
                        }
                        finally{
                            is.close();
                            is = null ;
                        }
                    }
                    finally{
                        os.close();
                        os = null ;
                    }
                }
                catch( Exception e ) {
                    outFile = null ;
                }
            }
            if( is != null ) {
                try {
                    is.close() ;
                } catch( Exception e ) {
                }
                is = null ;
            }
        }
        if( outFile != null ) {
            return outFile.getAbsolutePath() ;
        }
        return null ;
    }
    
    private static final boolean isLibFile( File f,InputStream in ) {
        boolean ret = false ;
        try {
            if( f.exists() == false ) {
                ret = true ;
            }
            else {
                int len = ( int )f.length() ;
                ret = ( len <= 0 || len != in.available() ) ;
            }
        } catch( Exception e ) {
            ret = true ;
        }
        return ret ;
    }
    
    protected static final boolean useInit() {
        return initFlag.get() ;
    }
    
    protected NativeIO() {
        
    }
    
    /** file-i/o. **/
    protected static native long open( int mode,int rw,byte[] file ) ;
    protected static native void close( long handle ) ;
    protected static native int read( long handle,long seek,byte[] out,int off,int len ) ;
    protected static native int write( long handle,long seek,byte[] in,int off,int len ) ;
    protected static native long getLength( long handle ) ;
    protected static native int setLength( long handle,long len ) ;
}

