package org.maachang.util.nativeio;

import java.io.File;
import java.io.IOException;

/**
 * NativeI/O定義.
 * 
 * @version 2008/11/29
 * @author  masahito suzuki
 * @since   MaachangBase-1.09
 */
abstract class NativeIODefine {
    
    /**
     * バージョン.
     */
    public static final String VERSION = "1.00" ;
    
    /**
     * ライブラリ名
     */
    protected static final String LIB_NAME = "mntv" ;
    
    /**
     * Windowsライブラリ拡張子.
     */
    protected static final String WINDOWS_LIB_PLUS = ".dll" ;
    
    /**
     * Linuxライブラリ拡張子.
     */
    protected static final String LINUX_LIB_PLUS = ".so" ;
    
    /**
     * Nativeライブラリパス.
     */
    protected static final String NATIVE_PACKAGE = "org/maachang/util/nativeio/native/" ;
    
    /**
     * デフォルトライブラリ格納ディレクトリ名.
     */
    protected static final String DEFAULT_DIR = ".lib_work" ;
    
    /** ファイル存在チェック. **/
    protected static final boolean useFile( String name ) {
        boolean ret;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            File file = new File(name);
            ret = (file.exists() == true) ? ((file.isDirectory() == false) ? file
                    .canRead()
                    : false)
                    : false;
        } catch (Exception e) {
            ret = false;
        }
        return ret;
    }
    
    /** 指定ファイル名をフルパス変換 **/
    protected static final String fullPath( String path ) throws IOException {
        return new File(path).getCanonicalPath();
    }
    
    /** 文字列をNative変換. **/
    protected static final byte[] nativeString( String s ) {
        if( s == null || ( s = s.trim() ).length() <= 0 ) {
            return new byte[ 1 ] ;
        }
        byte[] b = s.getBytes() ;
        int len = b.length ;
        byte[] ret = new byte[ len+1 ] ;
        System.arraycopy( b,0,ret,0,len ) ;
        ret[ len ] = 0 ;
        return ret ;
    }
}
