package org.maachang.comet;

import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicLONG;

/**
 * MaachangCometステータス管理.
 * 
 * @version 2008/10/24
 * @author masahito suzuki
 * @since MaachangComet 1.29
 */
public class State {
    
    /**
     * ステータス : 未定義.
     */
    public static final int NONE = -1 ;
    
    /**
     * ステータス : 起動中.
     */
    public static final int START_UP = 0 ;
    
    /**
     * ステータス : 正常起動.
     */
    public static final int SUCCESS = 1 ;
    
    /**
     * ステータス : シャットダウン中.
     */
    public static final int IS_SHUTDOWN = 2 ;
    
    /**
     * ステータス : 計画停止.
     */
    public static final int PLAN_STOP = 3 ;
    
    /**
     * シングルトン.
     */
    private static final State SNGL = new State() ;
    
    /**
     * 現在のステータス.
     */
    private final AtomicINT state = new AtomicINT( NONE ) ;
    
    /**
     * ステータス設定時間.
     */
    private final AtomicLONG time = new AtomicLONG( -1L ) ;
    
    /**
     * コンストラクタ.
     */
    private State() {
        
    }
    
    /**
     * オブジェクトを取得.
     * @return State オブジェクトが返されます.
     */
    public static final State getInstance() {
        return SNGL ;
    }
    
    /**
     * 新しいステータスを設定.
     * @param state 新しいステータスを設定します.
     */
    public void state( int state ) {
        this.state.set( state ) ;
        this.time.set( System.currentTimeMillis() ) ;
    }
    
    /**
     * 現在のステータスを取得.
     * @return int 現在のステータスが返されます.
     */
    public int state() {
        return state.get() ;
    }
    
    /**
     * ステータス更新時刻を取得.
     * @return long ステータス更新時刻が返されます.
     */
    public long time() {
        return time.get() ;
    }
    
    /**
     * ステータスを文字列で取得.
     * @return String ステータスが文字列で返されます.
     */
    public String toString() {
        return toString( state() ) ;
    }
    
    /**
     * ステータスを文字列で取得.
     * @param state 対象のステータスNoを設定します.
     * @return String ステータスが文字列で返されます.
     */
    public String toString( int state ) {
        switch( state ) {
            case NONE: return "未定義" ;
            case START_UP: return "起動中" ;
            case SUCCESS: return "正常起動" ;
            case IS_SHUTDOWN: return "停止中" ;
            case PLAN_STOP : return "計画停止" ;
        }
        return "不明" ;
    }
}
