package org.maachang.comet.httpd.engine;

import org.maachang.comet.MaachangDef;
import org.maachang.comet.httpd.HttpdExecutionManager;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.scripts.ScriptManager;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScript;
import org.maachang.util.FileUtil;

/**
 * HTTPDスクリプト実行管理.
 * 
 * @version 2007/08/30
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
class HttpdScriptManager implements HttpdExecutionManager {
    /**
     * Applicationディレクトリ.
     */
    private String appDirectory = null ;
    
    /**
     * コンストラクタ.
     */
    private HttpdScriptManager() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * カレントディレクトリを指定してオブジェクトを生成します.
     * <BR>
     * @param currentDirectory 対象のカレントディレクトリを設定します.
     * @exception Exception 例外.
     */
    public HttpdScriptManager( final String currentDirectory )
        throws Exception {
        this.appDirectory = new StringBuilder().
            append( ScriptDef.trimCurrentDirectory( currentDirectory ) ).
            append( MaachangDef.DIRECTORY_APPLICATION ).toString() ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        appDirectory = null ;
    }
    
    /**
     * 指定内容を取得.
     * <BR><BR>
     * 指定された内容を取得します.
     * <BR>
     * @param request 対象のリクエストを設定します.
     * @param response 対象のレスポンスを設定します.
     * @exception Exception 例外.
     */
    public void get( final HttpdRequest request,final HttpdResponse respons )
        throws Exception {
        ScriptManager.execution( request,respons,appDirectory ) ;
    }
    
    /**
     * 指定パスのファイル日付を取得.
     * <BR><BR>
     * 指定パスのファイル日付を取得します.
     * <BR>
     * @parma path 対象のパスを設定します.
     * @return long ファイル日付が返されます.
     */
    public long getFileTime( String path ) {
        path = ScriptManager.trimScriptPath( path ) ;
        if( path == null ) {
            return -1L ;
        }
        long ret = -1L ;
        // MTTML(Template)名でチェック.
        if( path.endsWith( ScriptManager.TEMPLATE_PLUS ) == true ) {
            try {
                ret = TemplateScript.getTime( path ) ;
                if( ret != -1L ) {
                    return ret ;
                }
            } catch( Exception e ) {
            }
            return -1L ;
        }
        String fullPath = appDirectory+path.substring( 1,path.length() ) ;
        // 通常名でチェック.
        if( ( ret = FileUtil.getLastTime( fullPath+ScriptManager.SCRIPT_PLUS ) ) != -1L ) {
            return ret ;
        }
        // コントローラ名でチェック.
        if( ( ret = FileUtil.getLastTime( fullPath+ScriptManager.SCRIPT_BY_CONTROLLER+ScriptManager.SCRIPT_PLUS ) ) != -1L ) {
            return ret ;
        }
        // MHTML名でチェック.
        if( ( ret = FileUtil.getLastTime( fullPath+ScriptManager.SCRIPT_HTML_PLUS ) ) != -1L ) {
            return ret ;
        }
        return -1L ;
    }
    
    /**
     * 指定パスの内容が存在するかチェック.
     * <BR><BR>
     * 指定パスの内容が存在するかチェックします.
     * <BR>
     * @param path 対象のパスを設定します.
     * @return boolean [true]の場合、存在します.
     */
    public boolean isPath( String path ) {
        path = ScriptManager.trimScriptPath( path ) ;
        if( path == null ) {
            return false ;
        }
        // MTTML(Template)名でチェック.
        if( path.endsWith( ScriptManager.TEMPLATE_PLUS ) == true ) {
            try {
                if( TemplateScript.isTemplate( path ) == true ) {
                    return true ;
                }
            } catch( Exception e ) {
            }
            return false ;
        }
        String fullPath = appDirectory+path.substring( 1,path.length() ) ;
        // 通常名でチェック.
        if( FileUtil.isFileExists( fullPath+ScriptManager.SCRIPT_PLUS ) == true ) {
            return true ;
        }
        // コントローラ名でチェック.
        if( FileUtil.isFileExists( fullPath+ScriptManager.SCRIPT_BY_CONTROLLER+ScriptManager.SCRIPT_PLUS ) == true ) {
            return true ;
        }
        // MHTML名でチェック.
        if( FileUtil.isFileExists( fullPath+ScriptManager.SCRIPT_HTML_PLUS ) == true ) {
            return true ;
        }
        return false ;
    }
    
    /**
     * 指定パスのディレクトリが存在するかチェック.
     * <BR><BR>
     * 指定パスのディレクトリが存在するかチェックします.
     * <BR>
     * @param path 対象のパスを設定します.
     * @return boolean [true]の場合、ディレクトリとして存在します.
     */
    public boolean isDirectory( String path ) {
        if( path.startsWith( "/" ) == true ) {
            path = path.substring( 1,path.length() ) ;
        }
        path = appDirectory + path ;
        if( FileUtil.isDirExists( path ) == true ) {
            return true ;
        }
        return false ;
    }
    
    /**
     * 指定パスの内容が読み込み可能かチェック.
     * <BR><BR>
     * 指定パスの内容が読み込み可能かチェックします.
     * <BR>
     * @param path 対象のパスを設定します.
     * @return boolean [true]の場合、読み込み可能です.
     */
    public boolean isRead( String path ) {
        path = ScriptManager.trimScriptPath( path ) ;
        if( path == null ) {
            return false ;
        }
        // MTTML(Template)名でチェック.
        if( path.endsWith( ScriptManager.TEMPLATE_PLUS ) == true ) {
            try {
                if( TemplateScript.isTemplate( path ) == true ) {
                    return true ;
                }
            } catch( Exception e ) {
            }
            return false ;
        }
        String fullPath = appDirectory+path.substring( 1,path.length() ) ;
        // 通常名でチェック.
        if( FileUtil.isRead( fullPath+ScriptManager.SCRIPT_PLUS ) == true ) {
            return true ;
        }
        // コントローラ名でチェック.
        if( FileUtil.isRead( fullPath+ScriptManager.SCRIPT_BY_CONTROLLER+ScriptManager.SCRIPT_PLUS ) == true ) {
            return true ;
        }
        // MHTML名でチェック.
        if( FileUtil.isRead( fullPath+ScriptManager.SCRIPT_HTML_PLUS ) == true ) {
            return true ;
        }
        return false ;
    }
    
}
