package org.maachang.comet.httpd.engine.comet ;

import java.util.LinkedList;

/**
 * Comet用コネクションキュー.
 * 
 * @version 2008/10/24
 * @author masahito suzuki
 * @since  MaachangComet 1.29
 */
class CometConnectQueue<T> {
    
    /** キュー管理 */
    private final LinkedList<T> queue = new LinkedList<T>() ;
    
    /**
     * コンストラクタ.
     */
    public CometConnectQueue() {
    }
    
    protected void finalize() throws Exception {
        this.clear() ;
    }
    
    /**
     * オブジェクトクリア.
     */
    public void clear() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    /**
     * データ追加.
     * @param value 追加対象のデータを設定します.
     */
    public void add( T value ) {
        if( queue == null || value == null ) {
            return ;
        }
        queue.add( value ) ;
    }
    
    /**
     * 先頭にデータ追加.
     * @param value 対象の情報を設定します.
     */
    public void addFirst( T value ) {
        if( queue == null || value == null ) {
            return ;
        }
        queue.addFirst( value ) ;
    }
    
    /**
     * 先頭データを取得して削除.
     * @return T 格納されているデータが返されます.
     */
    public T remove() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    /**
     * 削除.
     * @param no 対象の項番を設定します.
     * @return T 格納されている内容が返されます.
     */
    public T remove( int no ) {
        if( queue == null || queue.size() <= 0 ||
            no <= -1 || no >= queue.size() ) {
            return null ;
        }
        return queue.remove( no ) ;
    }
    
    /**
     * 取得.
     * @param no 対象の項番を設定します.
     * @return T 格納されている内容が返されます.
     */
    public T get( int no ) {
        if( queue == null || queue.size() <= 0 ||
            no <= -1 || no >= queue.size() ) {
            return null ;
        }
        return queue.get( no ) ;
    }
    
    /**
     * 格納数取得.
     * @return int 格納数が返されます.
     */
    public int size() {
        return queue.size() ;
    }
}
