package org.maachang.comet.httpd.engine.script.dao;

import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

/**
 * マスターキャッシュ子オブジェクト.
 * 
 * @version 2008/07/14
 * @author masahito suzuki
 * @since MaachangComet 1.1F
 */
public class MasterCacheChild {
    private final AtomicOBJECT<Object> value = new AtomicOBJECT<Object>() ;
    private final AtomicLONG lastAccessTime = new AtomicLONG( -1L ) ;
    
    public MasterCacheChild() {
        
    }
    
    public MasterCacheChild( Object value ) {
        if( value == null ) {
            this.value.set( null ) ;
            this.lastAccessTime.set( -1L ) ;
        }
        else {
            this.value.set( value ) ;
            this.lastAccessTime.set( System.currentTimeMillis() ) ;
        }
    }
    
    public void clearValue() {
        this.value.set( null ) ;
        this.lastAccessTime.set( -1L ) ;
    }
    
    public void setValue( Object value ) {
        if( value == null ) {
            this.value.set( null ) ;
            this.lastAccessTime.set( -1L ) ;
        }
        else {
            this.value.set( value ) ;
            this.lastAccessTime.set( System.currentTimeMillis() ) ;
        }
    }
    
    public Object getValue() {
        lastAccessTime.set( System.currentTimeMillis() ) ;
        return value.get() ;
    }
    
    public long getLastAccessTime() {
        return lastAccessTime.get() ;
    }
    
    public boolean isNoValue() {
        return ( value.get() == null ) ? true : false ;
    }
}
