// 帳票出力処理系.

Report = function() {}
Report.prototype = {
    // 帳票オブジェクト.
    engine : null,
    // 外部出力フラグ.
    resultFlag: false,
    // 帳票エンジンを生成.
    create : function( name ) {
        if( useString( name ) == false ) {
            return -1 ;
        }
        repFile = "./report/" ;
        if( startsWith( name,"/" ) || startsWith( name,"\\" ) ) {
            name = name.substring( 1 ) ;
        }
        if( endsWith( ".conf" ) == false ) {
            name += ".conf" ;
        }
        repFile += name ;
        this.engine = new org.maachang.report.ReportEngine( repFile ) ;
        return 0 ;
    },
    // 帳票エンジンを削除.
    destroy : function() {
        if( isNull( this.engine ) == false ) {
            this.engine.destroy() ;
        }
        this.engine = null ;
    },
    // リスト帳票改行処理.
    enter : function() {
        if( isNull( this.engine ) || this.engine.isUse() == false ) {
            return -1 ;
        }
        this.engine.nextList() ;
        return 0 ;
    },
    // 変数名を指定して情報追加.
    put : function( name,value ) {
        if( isNull( this.engine ) || this.engine.isUse() == false ) {
            return -1 ;
        }
        if( useString( name ) == false ) {
            return -1 ;
        }
        if( isNull( value ) ) {
            value = "" ;
        }
        var t = valueof( value ) ;
        if( t == "string" || t == "number" || t == "date" ) {
            if( valueof( value ) == "date" ) {
                value = new java.util.Date( value.getTime() ) ;
            }
            this.engine.putValue( name,value ) ;
            return 0 ;
        }
        return -1 ;
    },
    // 指定変数名が存在するかチェック.
    containsKey : function( name ) {
        if( isNull( this.engine ) || this.engine.isUse() == false ) {
            return false ;
        }
        if( useString( name ) == false ) {
            return false ;
        }
        return this.engine.containsKey( name ) ;
    },
    // データ群をセット.
    push : function( value ) {
        if( isNull( this.engine ) || this.engine.isUse() == false ) {
            return -1 ;
        }
        if( isNull( value ) ) {
            return -1 ;
        }
        var t = valueof( value ) ;
        if( t == "map" ) {
            for( var k in value ) {
                if( this.engine.containsKey( k ) ) {
                    this.put( k,value[k] ) ;
                }
            }
            return 0 ;
        }
        else if( t == "array" ) {
            var len = value.length ;
            var cnt = 0 ;
            for( var i = 0,cnt = 0 ; i < len ; i ++ ) {
                var o = value[ i ] ;
                if( valueof( o ) == "map" ) {
                    if( cnt != 0 ) {
                        this.enter() ;
                    }
                    for( var k in o ) {
                        if( this.engine.containsKey( k ) ) {
                            this.put( k,o[k] ) ;
                            cnt ++ ;
                        }
                    }
                }
            }
            return 0 ;
        }
        return -1 ;
    },
    // レスポンスに帳票データを出力.
    write : function( name ) {
        if( this.resultFlag ) {
            return 0 ;
        }
        if( isNull( this.engine ) || this.engine.isUse() == false ) {
            return -1 ;
        }
        if( isResponse() == false ) {
            return -1 ;
        }
        if( getHttpdResponse().isOutputStream() == true ) {
            return -1 ;
        }
        if( useString( name ) == false ) {
            name = this.engine.getOutName() ;
        }
        if( endsWith( name,".xls" ) == false ) {
            name += ".xls" ;
        }
        setDownloadContent( name ) ;
        responseToBinary( this.engine.getBytes(),"application/vnd.ms-excel" ) ;
        this.resultFlag = true ;
        return 0 ;
    },
    // ファイル出力.
    outFile : function( name ) {
        if( isNull( this.engine ) || this.engine.isUse() == false ) {
            return -1 ;
        }
        if( useString( name ) == false ) {
            return -1 ;
        }
        if( startsWith( name,"/" ) == false && startsWith( "\\" ) == false ) {
            name = "./public/" + name ;
        }
        this.engine.output( name ) ;
        return 0 ;
    }
} ;
