package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.MaachangDef;
import org.maachang.comet.httpd.engine.script.js.InitJS;

/**
 * Cometスクリプト情報.
 * 
 * @version 2008/11/18
 * @author masahito suzuki
 * @since MaachangComet 1.29
 */
public class CometScript extends AbstractScript {
    private CometScript() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を指定してオブジェクトを生成します.
     * <BR>
     * @param path 対象のパスを設定します.
     * @param currentDirectory カレントディレクトリを設定します.
     * @exception Exception 例外.
     */
    public CometScript( String path,String currentDirectory )
        throws Exception {
        this.create( "Comet",MaachangDef.DIRECTORY_APPLICATION,
            path,currentDirectory ) ;
    }
    
    /**
     * スクリプトタイプを取得.
     * <BR><BR>
     * スクリプトタイプを取得します.
     * <BR>
     * @return int スクリプトタイプが返されます.
     */
    public int getScriptType() {
        return ScriptManager.SCRIPT_TYPE_BY_COMET ;
    }
    
    /**
     * Headerスクリプトを設定.
     */
    protected String addHeaderScript() throws Exception {
        return InitJS.getInstance().get() ;
    }
    
    /**
     * Footerスクリプトを設定.
     */
    protected String addFooterScript() throws Exception {
        StringBuilder fooder = new StringBuilder() ;
        fooder.append( "\n var res =_$function$callCometAccessMethod() ;\n" ) ;
        // コンテンツタイプはJavascript.
        fooder.append( "setContentType( \"text/javascript\" ) ;\n" ) ;
        fooder.append( " httpPrintln( res ) ;\n" ) ;
        return fooder.toString() ;
    }
}
