package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.MaachangDef;
import org.maachang.comet.httpd.engine.script.js.InitJS;
import org.maachang.util.StringUtil;

/**
 * 帳票用スクリプト.
 * 
 * @version 2007/08/29
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class ReportScript extends AbstractScript {
    
    private ReportScript() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を指定してオブジェクトを生成します.
     * <BR>
     * @param path 対象のパスを設定します.
     * @param currentDirectory カレントディレクトリを設定します.
     * @exception Exception 例外.
     */
    public ReportScript( String path,String currentDirectory )
        throws Exception {
        this.create( "Report",MaachangDef.DIRECTORY_APPLICATION,
            path,currentDirectory ) ;
    }
    
    /**
     * スクリプトタイプを取得.
     * <BR><BR>
     * スクリプトタイプを取得します.
     * <BR>
     * @return int スクリプトタイプが返されます.
     */
    public int getScriptType() {
        return ScriptManager.SCRIPT_TYPE_BY_REPORT ;
    }
    
    /**
     * Headerスクリプトを設定.
     */
    protected String addHeaderScript() throws Exception {
        String p = path ;
        if( p.startsWith( "/" ) ) {
            p = p.substring( 1 ) ;
        }
        if( p.endsWith( ".ms" ) ) {
            p = p.substring( 0,p.length()-".ms".length() ) ;
        }
        if( p.endsWith( "Report" ) ) {
            p = p.substring( 0,p.length()-"Report".length() ) ;
        }
        p = StringUtil.changeString( p,"/","." ) ;
        return new StringBuilder().append( InitJS.getInstance().get() ).
            append( "\n" ).append( "var $report = new Report() ;\n" ).
            append( "$report.create( \"" ).append( p ).append( "\" ) ;\n" ).
            toString() ;
    }
    
    /**
     * Footerスクリプトを設定.
     */
    protected String addFooterScript() throws Exception {
        return "\n$report.write();\n$report.destroy();\n" ;
    }
}
