package org.maachang.comet.net.nio ;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * 読み込み可能キュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class IsReadQueue {
    private final ConcurrentLinkedQueue<NioElement> queue = new ConcurrentLinkedQueue<NioElement>() ;
    
    public IsReadQueue() {
    }
    
    protected void finalize() throws Exception {
        destroy() ;
    }
    
    public void destroy() {
        queue.clear() ;
    }
    
    public void append( final NioElement element ) {
        if( element != null ) {
            queue.offer( element ) ;
        }
    }
    
    public NioElement getQueue() {
        return queue.poll() ;
    }
    
    public int size() {
        return queue.size() ;
    }
}
