package org.maachang.comet.net.nio ;

import org.maachang.util.atomic.AtomicINT;


/**
 * KeepAlive情報を管理.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
public class KeepAliveFactory {
    
    /**
     * デフォルトKeepAlive時間.
     */
    private static final int DEF_TIME = 3 ;
    
    /**
     * デフォルトKeepAliveカウント.
     */
    private static final int DEF_COUNT = 100 ;
    
    /**
     * KeepAlive時間.
     */
    private final AtomicINT time = new AtomicINT( -1 ) ;
    
    /**
     * KeepAlive回数.
     */
    private final AtomicINT count = new AtomicINT( -1 ) ;
    
    /**
     * シングルトン.
     */
    private static final KeepAliveFactory SNGL = new KeepAliveFactory() ;
    
    /**
     * オブジェクトを取得.
     * @return KeepAliveFactory オブジェクトが返されます.
     */
    public static final KeepAliveFactory getInstance() {
        return SNGL ;
    }
    
    /**
     * コンストラクタ.
     */
    private KeepAliveFactory() {
        time.set( DEF_TIME ) ;
        count.set( DEF_COUNT ) ;
    }
    
    /**
     * KeepAlive値を設定.
     * @param time 対象の時間を設定します.
     * @param count 対象のカウントを設定します.
     */
    public void set( int time,int count ) {
        this.time.set( time ) ;
        this.count.set( count ) ;
    }
    
    /**
     * 新しいKeepAlive値を取得.
     * @return KeepAliveBean 新しいKeepAliveBeanが返されます.
     */
    public KeepAliveBean getBean() {
        return new KeepAliveBean( time.get(),count.get() ) ;
    }
}
