package org.maachang.comet.net.nio ;

import java.io.IOException;
import java.io.InputStream;

/**
 * Nio用InputStream.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class NioInputStream extends InputStream {
    
    private static final long TIMEOUT = 5000L ;
    private static final long MIN_TIMEOUT = 500L ;
    
    private ReceiveBuffer recvBuffer = null ;
    private long timeout = -1L ;
    
    public NioInputStream() {
        
    }
    
    public InputStream create( NioElement element )
        throws Exception {
        return create( element,TIMEOUT ) ;
    }
    
    public InputStream create( NioElement element,long timeout )
        throws Exception {
        if( element == null || element.isUse() == false ) {
            throw new IOException( "コネクションは既に破棄されています" ) ;
        }
        this.close() ;
        this.recvBuffer = element.getReceiveBuffer() ;
        this.timeout = ( timeout <= MIN_TIMEOUT ) ? MIN_TIMEOUT : timeout ;
        return this ;
    }
    
    protected void finalize() throws Exception {
        try {
            close() ;
        } catch( Exception e ) {
        }
    }
    
    public void close() {
        if( recvBuffer != null ) {
            recvBuffer.reset() ;
        }
        recvBuffer = null ;
    }
    
    public int available() throws IOException {
        if( isUse() == false ) {
            throw new IOException( "オブジェクトは既にクローズしています" ) ;
        }
        return recvBuffer.length() ;
    }
    
    public int read() throws IOException {
        if( isUse() == false ) {
            throw new IOException( "オブジェクトは既にクローズしています" ) ;
        }
        return recvBuffer.get( timeout ) ;
    }
    
    public int read(byte b[], int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException( "引数は不正です" );
        } else if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException( "範囲指定が不正です" );
        } else if (len == 0) {
            return 0;
        }
        return recvBuffer.get( timeout,b,off,len ) ;
    }
    
    public boolean markSupported() {
        return false ;
    }
    
    private boolean isUse() {
        return ( recvBuffer != null && recvBuffer.isUse() ) ;
    }
}
