package org.maachang.comet.net.nio ;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Nio用OutputStream.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class NioOutputStream extends OutputStream {
    protected static final int BUFFER_LENGTH = 1024 ;
    private NioElement element = null ;
    private SendBuffer sendBuffer = null ;
    private final byte[] temp = new byte[ BUFFER_LENGTH ] ;
    private int count = 0 ;
    
    public NioOutputStream() {
        
    }
    
    public NioOutputStream create( NioElement element ) throws Exception {
        if( element == null || element.isUse() == false ) {
            throw new IOException( "コネクションは既に破棄されています" ) ;
        }
        this.close() ;
        this.element = element ;
        this.sendBuffer = element.getSendBuffer() ;
        this.element.update() ;
        return this ;
    }
    
    protected void finalize() throws Exception {
        clear() ;
    }
    
    protected void clear() {
        if( sendBuffer != null && sendBuffer.isUse() ) {
            if( sendBuffer.isLast() == false ) {
                sendBuffer.last() ;
                try {
                    flushTo() ;
                } catch( Exception e ) {
                }
            }
        }
        element = null ;
        sendBuffer = null ;
        count = 0 ;
    }
    
    public void close() throws IOException {
        clear() ;
    }
    
    public void flush() throws IOException {
        if( sendBuffer == null || sendBuffer.isUse() == false ) {
            throw new IOException( "オブジェクトは既にクローズしています" ) ;
        }
        flushTo() ;
    }
    
    private void flushTo() throws IOException {
        if( count > 0 ) {
            sendBuffer.write( temp,count ) ;
            count = 0 ;
            // 送信処理が開始されていない場合は、送信処理を有効にする.
            element.restartWrite() ;
        }
        element.update() ;
    }
    
    public void write(int b) throws IOException {
        if( sendBuffer == null || sendBuffer.isUse() == false ) {
            throw new IOException( "オブジェクトは既にクローズしています" ) ;
        }
        if( count >= BUFFER_LENGTH ) {
            this.flush() ;
        }
        temp[ count ] = ( byte )b ;
        count ++ ;
    }
}
