package org.maachang.comet.net.nio ;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * 受信情報を保持したソケットオブジェクト管理キュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class ReceiveLinkQueue {
    private final ConcurrentLinkedQueue<NioElement> queue = new ConcurrentLinkedQueue<NioElement>() ;
    
    public ReceiveLinkQueue() {
    }
    
    protected void finalize() throws Exception {
        destroy() ;
    }
    
    public void destroy() {
        queue.clear() ;
    }
    
    public void append( final NioElement accept ) {
        if( accept != null ) {
            queue.offer( accept ) ;
        }
    }
    
    public NioElement getQueue() {
        return queue.poll() ;
    }
    
    public int size() {
        return queue.size() ;
    }
}
