package org.maachang.dao ;

import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.Record;

/**
 * DaoSession.
 *
 * @version 2007/11/03
 * @author  masahito suzuki
 * @since MaachangDao 1.00
 */
public class DaoSession {
    
    /**
     * コネクション情報.
     */
    private Record record = null ;
    
    /**
     * コンストラクタ.
     */
    protected DaoSession() {
        
    }
    
    /**
     * オブジェクト生成.
     * @param record 対象のレコードオブジェクトを設定します.
     * @exception MaachangDaoException MaachangDao例外.
     */
    protected synchronized void create( Record record ) throws MaachangDaoException {
        if( record == null ) {
            throw new MaachangDaoException( "引数は不正です" ) ;
        }
        this.record = record ;
    }
    
    /**
     * オブジェクトクリア.
     * <BR><BR>
     * オブジェクトの内容をクリアします.<BR>
     * このメソッドを呼び出した場合、内部のレコードは、クローズされません.
     */
    public synchronized void clear() {
        this.record = null ;
    }
    
    /**
     * レコード情報を取得.
     * <BR><BR>
     * レコード情報を取得します.
     * <BR>
     * @return Record レコード情報が返されます.
     */
    public synchronized Record getRecord() {
        return record ;
    }
    
    /**
     * 指定テーブル名のメタ情報を取得.
     * <BR><BR>
     * 指定テーブル名のメタ情報を取得します.
     * <BR>
     * @param name 対象のテーブル名を設定します.
     * @return MetaColumn 対象のメタカラムが返されます.
     * @exception MaachangDaoExceotion MaachangDao例外.
     */
    public MetaColumn getMeta( String name )
        throws MaachangDaoException {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new MaachangDaoException( "不正なモデル名です" ) ;
        }
        try {
            return this.record.getMetaColumn( DbUtil.convertJavaNameByDBName( name ) ) ;
        } catch( MaachangDaoException md ) {
            throw md ;
        } catch( Exception e ) {
            throw new MaachangDaoException( e ) ;
        }
    }
    
    /**
     * DaoSessionが利用中かチェック.
     * @return boolean [true]の場合は、利用中です.
     */
    public synchronized boolean isUsedObject() {
        return ( record != null ) ;
    }
}

