package org.maachang.dao.dbms.pool;

import java.sql.Connection;

/**
 * コネクション管理オブジェクト.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public class ConnectManager {
    /**
     * コネクション管理.
     */
    private DbcpPooling connectManager = null;

    /**
     * コンストラクタ.
     */
    private ConnectManager() {

    }

    /**
     * コンストラクタ. <BR>
     * <BR>
     * [OnePoolManager]を指定してオブジェクトを設定します. <BR>
     * 
     * @param connectManager
     *            対象オブジェクトを設定します.
     */
    protected ConnectManager(DbcpPooling connectManager) {
        this.connectManager = connectManager;
    }

    /**
     * ファイナライズ処理定義. <BR>
     * <BR>
     * ファイナライズ処理定義. <BR>
     * 
     * @exception Exception
     *                例外処理が返されます.
     */
    protected final void finalize() throws Exception {
        this.destroy();
    }

    /**
     * オブジェクト破棄. <BR>
     * <BR>
     * オブジェクトを破棄します.
     */
    public void destroy() {
        connectManager.destroy();
    }

    /**
     * コネクションオブジェクトを取得. <BR>
     * <BR>
     * コネクションオブジェクトを取得します. <BR>
     * 
     * @return Connection コネクションオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public Connection getConnection() throws Exception {
        return connectManager.getConnection();
    }

    /**
     * 最大プーリング数を取得. <BR>
     * <BR>
     * 最大プーリング数を取得します. <BR>
     * 
     * @return int 管理されている最大プーリング数が返されます.
     */
    public int getMax() {
        return connectManager.max();
    }

    /**
     * 現在アクティブであるプーリングコネクション数を取得. <BR>
     * <BR>
     * 現在アクティブであるプーリングコネクション数を取得します. <BR>
     * 
     * @return int 現在アクティブなプーリングコネクション数が返されます.
     */
    public int getActives() {
        return connectManager.active();
    }
    
    /**
     * 現在アイドルであるプーリングコネクション数を取得. <BR>
     * <BR>
     * 現在アイドルであるプーリングコネクション数を取得します. <BR>
     * 
     * @return int 現在アイドルなプーリングコネクション数が返されます.
     */
    public int getIdle() {
        return connectManager.idle();
    }
}
