package org.maachang.session.client.local ;

import org.maachang.session.client.PSession;
import org.maachang.session.client.PSessionManager;
import org.maachang.session.engine.PersistenceDefine;
import org.maachang.session.engine.PersistenceEngine;
import org.maachang.util.BaseRandom;

/**
 * クライアント永続化セッションローカル管理.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
class PSessionLocalManagerImpl implements PSessionManager {
    
    /**
     * PersistenceEngine.
     */
    private PersistenceEngine engine = null ;
    
    /**
     * コンストラクタ.
     */
    private PSessionLocalManagerImpl() {
        
    }
    
    /**
     * 削除時間タイム.
     */
    private long deleteTime = -1L ;
    
    /**
     * コンストラクタ.
     * @param engine 対象の永続化セッションエンジンを設定します.
     * @exception Exception 例外.
     */
    public PSessionLocalManagerImpl( PersistenceEngine engine )
        throws Exception {
        if( engine == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.engine = engine ;
    }
    
    /**
     * 新しいセッションIDを取得.
     * @param baseRandom ランダムオブジェクトを設定します.
     * @return String 新しいセッションIDが返されます.
     * @exception Exception 例外.
     */
    public String createSession( BaseRandom baseRandom ) throws Exception {
        return engine.createSessionId( baseRandom ) ;
    }
    
    /**
     * 指定セッションIDのセッションオブジェクトを取得.
     * @param baseRandom ランダムオブジェクトを設定します.
     * @return PSession セッションオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public PSession getSession( BaseRandom baseRandom ) throws Exception {
        return getSession( baseRandom,null ) ;
    }
    
    /**
     * 指定セッションIDのセッションオブジェクトを取得.
     * @param baseRandom ランダムオブジェクトを設定します.
     * @param sessionId 対象のセッションIDを設定します.
     * @return PSession セッションオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public PSession getSession( BaseRandom baseRandom,String sessionId ) throws Exception {
        if( sessionId == null ||
            ( sessionId = sessionId.trim() ).length() != PersistenceDefine.SESSION_KEY_LENGTH ) {
            sessionId = engine.createSessionId( baseRandom ) ;
        }
        if( engine.containsKey( sessionId ) == false ) {
            sessionId = engine.createSessionId( baseRandom ) ;
        }
        return new PSessionLocalImpl( sessionId,engine ) ;
    }
    
    /**
     * 指定セッションIDを削除.
     * @param sessionId 対象のセッションIDを設定します.
     * @exception Exception 例外.
     */
    public void reomveSession( String sessionId ) throws Exception {
        if( sessionId == null ||
            ( sessionId = sessionId.trim() ).length() != PersistenceDefine.SESSION_KEY_LENGTH ) {
            throw new IllegalArgumentException( "指定セッションIDは不正です" ) ;
        }
        engine.remove( sessionId ) ;
    }
    
    /**
     * 指定セッションIDが存在するかチェック.
     * @param sessionId 対象のセッションIDを設定します.
     * @return boolean [true]の場合、セッション情報は存在します.
     * @exception Exception 例外.
     */
    public boolean isSession( String sessionId ) throws Exception {
        if( sessionId == null ||
            ( sessionId = sessionId.trim() ).length() != PersistenceDefine.SESSION_KEY_LENGTH ) {
            return false ;
        }
        return engine.containsKey( sessionId ) ;
    }
    
    /**
     * セッション削除時間を取得.
     * @return long セッション削除時間が返されます.
     * @exception Exception 例外.
     */
    public long getDeleteSessionTime() throws Exception {
        if( deleteTime > 0 ) {
            return deleteTime ;
        }
        deleteTime = engine.getDeleteSessionTime() ;
        return deleteTime ;
    }
    
}

