package org.maachang.session.engine ;

import java.util.concurrent.ConcurrentSkipListSet;

/**
 * セッションIDロック.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
class SessionIdLock {
    
    /**
     * ロックスリープ時間.
     */
    private static final long SLEEP_TIME = 1L ;
    
    /**
     * ロック名群.
     */
    private final ConcurrentSkipListSet<String> manager = new ConcurrentSkipListSet<String>() ;
    
    /**
     * コンストラクタ.
     */
    public SessionIdLock() {
    }
    
    /**
     * 指定名でロック.
     * @param name 対象の名前を設定します.
     * @exceptino InterruptedException スレッド割り込み例外.
     */
    public void lock( String name ) throws InterruptedException {
        if( name == null || name.length() <= 0 ) {
            return ;
        }
        while( true ) {
            if( manager.contains( name ) == false ) {
                manager.add( name ) ;
                break ;
            }
            Thread.sleep( SLEEP_TIME ) ;
        }
    }
    
    /**
     * 指定名でアンロック.
     * @param name 対象の名前を設定します.
     */
    public void unlock( String name ) {
        if( name == null || name.length() <= 0 ) {
            return ;
        }
        manager.remove( name ) ;
    }
}
