package org.maachang.rawio ;

/**
 * CPU情報関連を取得.
 *  
 * @version 2008/09/28
 * @author  masahito suzuki
 * @since   Rawio 1.02
 */
public class Cpu {
    private Cpu() {}
    
    /**
     * CPU利用率を取得.
     * @return double CPU利用率が返されます.
     */
    public static final double useCpu() {
        if( NativeRawIO.useInit() ) {
            return NativeRawIO.getUseCpu() ;
        }
        return 0.0f ;
    }
    
    /**
     * プロセスIDを取得.
     * @return int プロセスIDが返されます.
     */
    public static final int getProcessId() {
        if( NativeRawIO.useInit() ) {
            return NativeRawIO.getProcessId() ;
        }
        return -1 ;
    }
    
}