package org.maachang.rawio ;

import java.io.IOException;

import org.maachang.rawio.mapping.MappingioInstance;

/**
 * rawio生成用オブジェクト.
 *  
 * @version 2008/06/12
 * @author  masahito suzuki
 * @since   Rawio 1.00
 */
public abstract class RawioInstance {
    private RawioInstance() {}
    
    /**
     * 新しいRawI/Oオブジェクトを生成.
     * @param name 対象のファイル名を設定します.
     * @return Baseio Baseioオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final Baseio open( String name ) throws Exception {
        return open( false,name ) ;
    }
    
    /**
     * 新しいRawI/Oオブジェクトを生成.
     * @param mode [true]の場合、Mappingオブジェクトで生成します.
     * @param name 対象のファイル名を設定します.
     * @return Baseio Baseioオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final Baseio open( boolean mode,String name ) throws Exception {
        Baseio ret ;
        if( NativeRawIO.useInit() == false ) {
            ret = new EmulationRawIOImpl( name ) ;
        }
        else {
            ret = new DirectIOImpl( name ) ;
        }
        if( mode ) {
            ret = MappingioInstance.getInstance( ret ) ;
        }
        return ret ;
    }
    
    /**
     * 新しいRawI/Oオブジェクトを生成.<BR>
     * DirectI/Pオブジェクトが生成できない場合は、例外が発生します.
     * @param name 対象のファイル名を設定します.
     * @return Baseio Baseioオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final Baseio openDirect( String name ) throws Exception {
        return openDirect( false,name ) ;
    }
    
    /**
     * 新しいRawI/Oオブジェクトを生成.<BR>
     * DirectI/Pオブジェクトが生成できない場合は、例外が発生します.
     * @param mode [true]の場合、Mappingオブジェクトで生成します.
     * @param name 対象のファイル名を設定します.
     * @return Baseio Baseioオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final Baseio openDirect( boolean mode,String name ) throws Exception {
        Baseio ret ;
        if( NativeRawIO.useInit() == false ) {
            throw new IOException( "DirectI/Oの生成に失敗しました" ) ;
        }
        else {
            ret = new DirectIOImpl( name ) ;
        }
        if( mode ) {
            ret = MappingioInstance.getInstance( ret ) ;
        }
        return ret ;
    }
    
    /**
     * 新しいRawI/Oオブジェクトを生成.<BR>
     * 通常のRandomAccessFileでのエミュレーション用オブジェクトで生成します.
     * @param name 対象のファイル名を設定します.
     * @return Baseio Baseioオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final Baseio openEmulation( String name ) throws Exception {
        return openEmulation( false,name ) ;
    }
    
    /**
     * 新しいRawI/Oオブジェクトを生成.<BR>
     * 通常のRandomAccessFileでのエミュレーション用オブジェクトで生成します.
     * @param mode [true]の場合、Mappingオブジェクトで生成します.
     * @param name 対象のファイル名を設定します.
     * @return Baseio Baseioオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final Baseio openEmulation( boolean mode,String name ) throws Exception {
        Baseio ret = new EmulationRawIOImpl( name ) ;
        if( mode ) {
            ret = MappingioInstance.getInstance( ret ) ;
        }
        return ret ;
    }
    
    /**
     * 指定ファイル名のセクタ長を取得.
     * @param name パス名を設定します.
     * @return int セクタ長が返されます.
     * @exception Exception 例外.
     */
    public static final int getSector( String name ) throws Exception {
        if( NativeRawIO.useInit() == false ) {
            return 512 ;
        }
        String path = DirectIOImpl.getPath( name ) ;
        int ret = NativeRawIO.getSector( NativeRawIO.nativeString( path ) ) ;
        if( ret <= -1 ) {
            throw new IOException( "セクタ長の取得に失敗しました" ) ;
        }
        return ret ;
    }
}
