/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JavaPackageList {
    private JavaCompiler compiler = null;
    private JavaFileManager fileManager = null;
    private Set<JavaFileObject.Kind> kind = null;
    public static final JavaPackageList SNGL = new JavaPackageList();
    private static final int CLAZZ_NAME_LENGTH = 6;

    private JavaPackageList() {
        try {
            this.compiler = ToolProvider.getSystemJavaCompiler();
            this.fileManager = this.compiler.getStandardFileManager(new DiagnosticCollector(), null, null);
            this.kind = new HashSet<JavaFileObject.Kind>();
            this.kind.add(JavaFileObject.Kind.CLASS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final JavaPackageList getInstance() {
        return SNGL;
    }

    public List<String> getList(String packageName) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        this.getList(ret, packageName);
        return ret;
    }

    public int getList(List<String> out, String packageName) throws Exception {
        String n;
        if (out == null || packageName == null || (packageName = packageName.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        out.clear();
        int ret = 0;
        Iterable<JavaFileObject> ib = this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, packageName, this.kind, false);
        if (ib != null) {
            for (JavaFileObject f : ib) {
                n = f.getName();
                out.add(n.substring(0, n.length() - 6));
                ++ret;
            }
        }
        if (ret == 0 && (ib = this.fileManager.list(StandardLocation.CLASS_PATH, packageName, this.kind, false)) != null) {
            for (JavaFileObject f : ib) {
                n = f.getName();
                out.add(n.substring(0, n.length() - 6));
                ++ret;
            }
        }
        return ret;
    }

    public int getList(Map<String, String> out, String packageName) throws Exception {
        if (out == null || packageName == null || (packageName = packageName.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        out.clear();
        int ret = 0;
        Iterable<JavaFileObject> ib = this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, packageName, this.kind, false);
        if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        if (ib != null) {
            for (JavaFileObject f : ib) {
                String n = f.getName();
                n = n.substring(0, n.length() - 6);
                out.put(n, packageName + n);
                ++ret;
            }
        }
        return ret;
    }

    public boolean isObject(String packageName, String objectName) throws Exception {
        if (packageName == null || (packageName = packageName.trim()).length() <= 0 || objectName == null || (objectName = objectName.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Iterable<JavaFileObject> ib = this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, packageName, this.kind, false);
        if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        if (ib != null) {
            for (JavaFileObject f : ib) {
                String n = f.getName();
                if (!objectName.equals(n = n.substring(0, n.length() - 6))) continue;
                return true;
            }
        }
        return false;
    }
}

