package org.maachang.reflect ;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * プリミティブ系処理.
 *
 * @version 2009/03/30
 * @author  masahito suzuki
 * @since   FastReflect 1.00
 */
abstract class FastReflectPrimitive {
    private FastReflectPrimitive() {}
    
    /** 非パラメータ. **/
    protected static final Object[] NO_PARAM = new Object[ 0 ] ;
    
    /** 非パラメータクラス **/
    protected static final Class[] NO_PARAM_CLASS = new Class[ 0 ] ;
    
    /** プリミティブ型. **/
    protected static final Set<Class> PRIMITIVE ;
    
    /** プリミティブ型変換処理. **/
    protected static final Map<Class,Class> CONV_PRIMITIVE ;
    
    /** 数値プリミティブSet. **/
    protected static final Set<Class> NUMBER_PRIMITIVE ;
    
    static {
        // primitive.
        Set<Class> m = new HashSet<Class>() ;
        m.add( java.lang.Boolean.class ) ;
        m.add( java.lang.Byte.class ) ;
        m.add( java.lang.Character.class ) ;
        m.add( java.lang.Short.class ) ;
        m.add( java.lang.Integer.class ) ;
        m.add( java.lang.Long.class ) ;
        m.add( java.lang.Float.class ) ;
        m.add( java.lang.Double.class ) ;
        m.add( Boolean.TYPE ) ;
        m.add( Byte.TYPE ) ;
        m.add( Character.TYPE ) ;
        m.add( Short.TYPE ) ;
        m.add( Integer.TYPE ) ;
        m.add( Long.TYPE ) ;
        m.add( Float.TYPE ) ;
        m.add( Double.TYPE ) ;
        
        // primitveからプリミティブラッパーオブジェクト変換.
        Map<Class,Class> x = new HashMap<Class,Class>() ;
        x.put( Boolean.TYPE,java.lang.Boolean.class ) ;
        x.put( Byte.TYPE,java.lang.Byte.class ) ;
        x.put( Character.TYPE,java.lang.Character.class ) ;
        x.put( Short.TYPE,java.lang.Short.class ) ;
        x.put( Integer.TYPE,java.lang.Integer.class ) ;
        x.put( Long.TYPE,java.lang.Long.class ) ;
        x.put( Float.TYPE,java.lang.Float.class ) ;
        x.put( Double.TYPE,java.lang.Double.class ) ;
        x.put( java.lang.Boolean.class,java.lang.Boolean.class ) ;
        x.put( java.lang.Byte.class,java.lang.Byte.class ) ;
        x.put( java.lang.Character.class,java.lang.Character.class ) ;
        x.put( java.lang.Short.class,java.lang.Short.class ) ;
        x.put( java.lang.Integer.class,java.lang.Integer.class ) ;
        x.put( java.lang.Long.class,java.lang.Long.class ) ;
        x.put( java.lang.Float.class,java.lang.Float.class ) ;
        x.put( java.lang.Double.class,java.lang.Double.class ) ;
        
        // 数値プリミティブ判別用Set.
        Set<Class> y = new HashSet<Class>() ;
        y.add( Byte.TYPE ) ;
        y.add( Character.TYPE ) ;
        y.add( Short.TYPE ) ;
        y.add( Integer.TYPE ) ;
        y.add( Long.TYPE ) ;
        y.add( Float.TYPE ) ;
        y.add( Double.TYPE ) ;
        y.add( Byte.class ) ;
        y.add( Character.class ) ;
        y.add( Short.class ) ;
        y.add( Integer.class ) ;
        y.add( Long.class ) ;
        y.add( Float.class ) ;
        y.add( Double.class ) ;
        
        PRIMITIVE = m ;
        CONV_PRIMITIVE = x ;
        NUMBER_PRIMITIVE = y ;
    }
    
    /** 文字列. **/
    protected static final Class STRING = String.class ;
    
    /** オブジェクト. **/
    protected static final Class OBJECT = Object.class ;
    
    /**
     * プリミティブ条件を、プリミティブラッパークラスに変換.
     * @param clazz 対象のクラスを設定します.
     * @return Class 変換されたクラス情報が返されます.
     */
    public static final Class convertClass( final Class clazz ) {
        Class c = CONV_PRIMITIVE.get( clazz ) ;
        if( c == null ) {
            return clazz ;
        }
        return c ;
    }
    
    /**
     * プリミティブ条件かチェック.
     * @param clazz 対象のクラスを設定します.
     * @return boolean [true]の場合、プリミティブ型です.
     */
    public static final boolean isPrimitive( final Class clazz ) {
        return PRIMITIVE.contains( clazz ) ;
    }
}

