/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jrule;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.jrule.Assert;
import jp.sourceforge.jrule.ClassRule;
import jp.sourceforge.jrule.ParseException;
import jp.sourceforge.jrule.PropertyRule;
import jp.sourceforge.jrule.Rule;
import jp.sourceforge.jrule.RuleRepository;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.SequencedHashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RuleParser {
    private SequencedHashMap rules = new SequencedHashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public RuleParser() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.jrule.impl.NotNullRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rules.put((Object)"notNull", (Object)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("jp.sourceforge.jrule.impl.BetweenLengthRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rules.put((Object)"betweenLength", (Object)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("jp.sourceforge.jrule.impl.CardinalityRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rules.put((Object)"cardinality", (Object)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("jp.sourceforge.jrule.impl.MaxLengthRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rules.put((Object)"maxLength", (Object)clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("jp.sourceforge.jrule.impl.MaxNumberRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rules.put((Object)"maxNumber", (Object)clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("jp.sourceforge.jrule.impl.MinLengthRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rules.put((Object)"minLength", (Object)clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("jp.sourceforge.jrule.impl.MinNumberRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rules.put((Object)"minNumber", (Object)clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("jp.sourceforge.jrule.impl.PatternRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rules.put((Object)"pattern", (Object)clazz8);
    }

    public Rule createRule(String ruleName) throws InstantiationException {
        Class ruleClass = (Class)this.rules.get((Object)ruleName);
        try {
            return (Rule)ruleClass.newInstance();
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    public void addRuleClass(String ruleName, String ruleClassName) throws ClassNotFoundException {
        Assert.assertNotNull(ruleName);
        Assert.assertNotNull(ruleClassName);
        this.rules.put((Object)ruleName, Class.forName(ruleClassName));
    }

    public List listRuleClass() {
        return this.rules.sequence();
    }

    public RuleRepository parse(InputStream xmlInput) throws ParseException {
        Assert.assertNotNull(xmlInput);
        RuleRepository repository = new RuleRepository();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(xmlInput);
            Element root = doc.getDocumentElement();
            this.populate(repository, root);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        return repository;
    }

    public void populate(RuleRepository repository, Element element) throws ParseException {
        NodeList classRuleList;
        Assert.assertNotNull(repository);
        Assert.assertNotNull(element);
        NodeList defineTagList = element.getElementsByTagName("definetag");
        if (defineTagList != null) {
            try {
                int i = 0;
                while (i < defineTagList.getLength()) {
                    Element defineTagElement = (Element)defineTagList.item(i);
                    String name = defineTagElement.getAttribute("name");
                    String className = defineTagElement.getAttribute("className");
                    this.rules.put((Object)name, Class.forName(className));
                    ++i;
                }
            }
            catch (ClassNotFoundException e) {
                throw new ParseException(e);
            }
        }
        if ((classRuleList = element.getElementsByTagName("class")) != null) {
            int i = 0;
            while (i < classRuleList.getLength()) {
                Element classRuleElement = (Element)classRuleList.item(i);
                ClassRule classRule = new ClassRule();
                classRule.setName(classRuleElement.getAttribute("name"));
                classRule.setTestcase(classRuleElement.getAttribute("testcase"));
                NodeList propertyRuleList = classRuleElement.getElementsByTagName("property");
                if (propertyRuleList != null) {
                    int j = 0;
                    while (j < propertyRuleList.getLength()) {
                        Element propertyElement = (Element)propertyRuleList.item(j);
                        PropertyRule propertyRule = new PropertyRule();
                        propertyRule.setName(propertyElement.getAttribute("name"));
                        NodeList childNode = propertyElement.getChildNodes();
                        if (childNode != null) {
                            int k = 0;
                            while (k < childNode.getLength()) {
                                Node node = childNode.item(k);
                                if (node.getNodeType() == 1) {
                                    Element ruleElement = (Element)node;
                                    try {
                                        Rule rule = this.createRule(ruleElement.getTagName());
                                        Map attributes = this.convertAtributeMapToMap(ruleElement.getAttributes());
                                        BeanUtils.populate((Object)rule, (Map)attributes);
                                        propertyRule.addRule(rule);
                                    }
                                    catch (InstantiationException e) {
                                        throw new ParseException(e);
                                    }
                                    catch (IllegalAccessException e) {
                                        throw new ParseException(e);
                                    }
                                    catch (InvocationTargetException e) {
                                        throw new ParseException(e);
                                    }
                                }
                                ++k;
                            }
                        }
                        classRule.addPropertyRule(propertyRule);
                        ++j;
                    }
                }
                repository.addClassRule(classRule);
                ++i;
            }
        }
    }

    private Map convertAtributeMapToMap(NamedNodeMap atributeMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (atributeMap == null) {
            return map;
        }
        int i = 0;
        while (i < atributeMap.getLength()) {
            Attr attr = (Attr)atributeMap.item(i);
            map.put(attr.getName(), attr.getValue());
            ++i;
        }
        return map;
    }
}

