/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005-2007 by Y.D.K.Co.,LTD Technologies company
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: ns9360.ld,v 1.1 2007/05/11 06:06:35 honda Exp $
 */
/*
 * OUTPUT_FORMAT("elf32-littlearm", "elf32-bigarm","elf32-littlearm") 
*/
OUTPUT_FORMAT("elf32-bigarm")
OUTPUT_ARCH(arm)
	
PROVIDE(hardware_init_hook = 1);
PROVIDE(software_init_hook = 0);
PROVIDE(software_term_hook = 0);

SECTIONS
{
    . = 0x00 ;    
    .vector :
    {
    *(.vector)
    }
    
    .text :	
    {
        __text = . ; 	
        *(.text)
    }
    _etext = .	;
    PROVIDE (etext = .)	;
    .rodata : { *(.rodata) }
    . = ALIGN(4);
    .ctors :
    {
        PROVIDE(__CTOR_BEGIN__ = .);
        KEEP (*(SORT(.ctors.*)))
        KEEP (*(.ctors))
        PROVIDE(__CTOR_END__ = .);
    }
    . = ALIGN(4);
    .dtors :
    {
        PROVIDE(__DTOR_BEGIN__ = .);
        KEEP (*(SORT(.dtors.*)))
        KEEP (*(.dtors))
        PROVIDE(__DTOR_END__ = .);
       _endtext = .;
    }
    __idata_start = . ;
  .data :AT (_endtext)
  {
    _etext = _endtext;
    __data_start = .;
    PROVIDE (data_start = .);
    *(.data)
    *(.gnu.linkonce.d*)
    SORT(CONSTRUCTORS)
    *(.data1)
        *(.eh_frame)
        *(.jcr)
        *(.gcc_except_table)
    . = ALIGN(0x10);
  }
    __idata_end = __idata_start + SIZEOF(.data);

    .bss  : AT (_endtext  + SIZEOF(.data))
    {
      __bss_start = . ;
      *(.bss)
      *(COMMON)
      *(.stack)
      . += 12K;
      _stack_end = . ;
      PROVIDE (stack_end  = .)	;
    }

    _end = .		;
    __bss_end = .;
    PROVIDE (end = .)	;
 
   .ttb    : AT (__idata_end + SIZEOF(.bss))
  {
   . = ALIGN(0x4000);
   ttb_start = . ;
   *(.ttb)
   . += 32K;
   ttb_end = . ;
  }

    .comment 0 : { *(.comment) }	
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }	
  .debug_info 0 : { *(.debug_info) }
  .debug_abbrev 0 : { *(.debug_abbrev) }
  .debug_line 0 : { *(.debug_line) }
  .debug_frame 0 : { *(.debug_frame) }
  .debug_str 0 : { *(.debug_str) }
  .debug_loc 0 : { *(.debug_loc) }
  .debug_macinfo 0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames 0 : { *(.debug_varnames) }
  /* These must appear regardless of  .  */
}	

	
		
	