/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: hw_serial.c,v 1.7 2007/03/23 07:58:33 honda Exp $
 */

/*
 *  åȰ¸ꥢI/O⥸塼H8ѡ
 *    ݡȤ 1ܤξ HWPORT1_ADDR˻ꤵ줿ݡȤѤ
 *      2ܤξϡHWPORT1_ADDR桼ѡHWPORT2_ADDR򥳥󥽡
 *      ϤȤƻѤ롣
 *      HWPORTx_ADDR åȰ¸ sys_config.hǻꤹ롣
 *    Υ⥸塼ˤäơXON/XOFFե椬Ԥ
 *      ƤΤǡTxDRxD2ܤǤ褤
 */

#include "jsp_kernel.h"
#include <hw_serial.h>

/*
 *  ꥢݡȤν֥å
 */
static const SIOPINIB siopinib_table[TNUM_PORT] = {
        {
                (UB*)SCI_PORT1_BASE,
                SCI_PORT1_BAUD_RATE,
                {
                        (UB*)SCI_PORT1_IPR,
                        SCI_PORT1_IPR_BIT,
                        SCI_PORT1_IPM
                },
                SCI_PORT1_SMR
        }

#if TNUM_PORT == 2u
        ,{
                (UB*)SCI_PORT2_BASE,
                SCI_PORT2_BAUD_RATE,
                {
                        (UB*)SCI_PORT2_IPR,
                        SCI_PORT2_IPR_BIT,
                        SCI_PORT2_IPM
                },
                SCI_PORT2_SMR
        }
#endif  /* of #if TNUM_PORT == 2u */

};


/*
 *  ꥢݡȤ֥å
 */
SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ֥åؤѴ
 */
Inline SIOPINIB*
get_siopinib(ID sioid)
{
	UINT index = INDEX_SIO(sioid);
	
	assert(index < TNUM_PORT);
	
    return(&(siopinib_table[index]));
}

/*
 *  ܡ졼ȤBRR쥸ͤؤѴ
 *  黻ǥСեʤ褦UWѤƤ
 */
Inline UB 
baud_to_brr(UW baud)
{
	UB brr;
	
	if (baud > 38400ul) {
		brr = (UB)(((CPU_CLOCK+(16ul*baud)) / (32ul*baud))-1ul);
	} else {
		brr = (UB)((CPU_CLOCK / (32ul*baud))-1ul);
	}
	return brr;
}

/*
 *  ܡ졼Ԥ[nsec]ޥ
 *  黻ǥСեʤ褦UW˥㥹ȤƤ
 */
#define SCI_SETUP_TIME(b)       (((1000000ul / (b)) + 1ul) * 1000ul)

/*
 *  SCI ν
 */
void
SCI_initialize (ID sioid)
{
        const SIOPINIB  *inib = get_siopinib(sioid);
        
        assert(inib != (SIOPINIB*)NULL);
        SCI_cls_por(inib->base);

        sil_wrb_mem((VP)(inib->base + H8SMR), (VB)(inib->smr_init));

                                        /*  ܡ졼      */
        sil_wrb_mem((VP)(inib->base + H8BRR), (VB)baud_to_brr(inib->baudrate));

                        /* ߶ػߤȥå     */
        h8_anb_reg(inib->base + H8SCR,
                     (UB)~(H8SCR_TIE  | H8SCR_RIE  | H8SCR_MPIE | H8SCR_TEIE |
                                                              H8SCR_CKE1 | H8SCR_CKE0 ));

        /* ܡ졼Ȥ塢1ӥåʬԤʤФʤʤ*/
        sil_dly_nse_long(SCI_SETUP_TIME(inib->baudrate));

                                        /* 顼ե饰򥯥ꥢ         */
        h8_anb_reg(inib->base + H8SSR, (UB)~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));

        /*
         *  ץ饤ƥ٥
         *      ϳߥȥ¸ʬʬΥ٤
         */
        define_int_plevel(&(inib->irc));

        /* ߤߤεĤϥꥢ I/O ǹԤ */
        /*  */

        h8_orb_reg(inib->base + H8SCR, (UB)(H8SCR_TE | H8SCR_RE));
}

/*
 *  SCI Υ
 */
void
SCI_cls_por (UB *base)
{
	    UB ssr;
	    
        /* TDRE  1 ˤʤޤԤ */
        do {
			ssr = sil_reb_mem((VP)(base + H8SSR));
			ssr &= H8SSR_TDRE;
        } while(ssr == 0u);

        /* 11ӥåʬԤġ*/
        /*
         * ׸Ƥ1.2msecꤹΤǡ¾νCPU
         * ä󥿥ƥȤ
         * ƤФǽΤǡΤޤޤˤƤ롣
         */
        sil_dly_nse_long(SCI_SETUP_TIME(H8_MIN_BAUD_RATE)*11ul);

                                        /*            */
        h8_anb_reg(base + H8SCR,
                    (UB)(~(H8SCR_TIE | H8SCR_RIE | H8SCR_TE | H8SCR_RE)));
}

/*
 *  SCI_in_handler -- SCI ϳߥϥɥ
 */
void
SCI_in_handler(ID sioid)
{
        SIOPCB  *pcb = get_siopcb(sioid);
        UB      status = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
		UB      flag = (UB)(status & (H8SSR_ORER | H8SSR_FER | H8SSR_PER));

        if (flag != 0) {

                /* 顼           */

                /* 顼ե饰򥯥ꥢ */
                sil_wrb_mem((VP)(pcb->inib->base + H8SSR),
                            (VB)(status & ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER)));
        }

		flag = (UB)(status & H8SSR_RDRF);
        if (flag != 0) {
                if (pcb->openflag == TRUE) {
                        /* ǽХå롼ƽФ*/
                        SCI_ierdy_rcv(pcb->exinf);
                } else {
                        sil_wrb_mem((VP)(pcb->inib->base + H8SSR), (VB)(status & ~H8SSR_RDRF));
                }
        }
}

/*
 *  SCI_out_handler -- SCI ϳߥϥɥ
 */
void
SCI_out_handler(ID sioid)
{
        SIOPCB  *pcb;

        pcb = get_siopcb(sioid);
        if (pcb->openflag == TRUE) {
                /* ǽХå롼ƽФ*/
                SCI_ierdy_snd(pcb->exinf);
        }
}

#ifdef H8_CFG_SCI_ERR_HANDLER

/*
 *  SCI_err_handler -- SCI 顼ϳߥϥɥ
 */
void
SCI_err_handler(ID sioid)
{
        SIOPCB  *pcb;
        UB      status;

        pcb = get_siopcb(sioid);
        status = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
        if (status & (H8SSR_ORER | H8SSR_FER | H8SSR_PER)) {

                /* 顼           */

                /* 顼ե饰򥯥ꥢ */
                sil_wrb_mem((VP)(pcb->inib->base + H8SSR),
                            status & ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));
        }
}

#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

/*
 *  sio_initialize -- ꥢݡȥɥ饤Фν
 */
void
sio_initialize(void)
{
        INT ix;

        /* SIO ֥åν */
        for (ix = 0; ix < TNUM_PORT; ix++) {
                siopcb_table[ix].inib     = &siopinib_table[ix];
                siopcb_table[ix].openflag = FALSE;
        }
}

/*
 *  sio_ena_cbr -- ꥢ I/O ΥХåε
 */
void
sio_ena_cbr(SIOPCB *pcb, UINT cbrtn)
{
        switch (cbrtn) {
        case SIO_ERDY_SND:
                SCI_enable_send(pcb);
                break;
        case SIO_ERDY_RCV:
                SCI_enable_recv(pcb);
                break;
        default:
                assert(FALSE);
        }
}

/*
 *  sio_dis_cbr -- ꥢ I/O ΥХåζػ
 */
void
sio_dis_cbr(SIOPCB *pcb, UINT cbrtn)
{
        switch (cbrtn) {
        case SIO_ERDY_SND:
                SCI_disable_send(pcb);
                break;
        case SIO_ERDY_RCV:
                SCI_disable_recv(pcb);
                break;
        default:
                assert(FALSE);
        }
}

/*
 *  SCI 
 */
void
sio_in_handler (void)
{
        SCI_in_handler(SCI_PORTID1);
}

void
sio_out_handler (void)
{
        SCI_out_handler(SCI_PORTID1);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err_handler (void)
{
        SCI_err_handler(SCI_PORTID1);
}

#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#if TNUM_PORT >= 2u

void
sio_in2_handler (void)
{
        SCI_in_handler(SCI_PORTID2);
}

void
sio_out2_handler (void)
{
        SCI_out_handler(SCI_PORTID2);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err2_handler (void)
{
        SCI_err_handler(SCI_PORTID2);
}

#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#endif  /* of #if TNUM_PORT >= 2u */
