/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2010 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: hw_serial.h,v 1.17 2007/03/23 07:22:15 honda Exp $
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

/*
 *  åȰ¸ꥢI/O⥸塼H8ѡ
 *    ݡȤ 1ܤξ HWPORT1_ADDR˻ꤵ줿ݡȤѤ
 *      2ܤξϡHWPORT1_ADDR桼ѡHWPORT2_ADDR򥳥󥽡
 *      ϤȤƻѤ롣
 *      HWPORTx_ADDR åȰ¸ sys_config.hǻꤹ롣
 *    Υ⥸塼ˤäơXON/XOFFե椬Ԥ
 *      ƤΤǡTxDRxD2ܤǤ褤
 */

#include <s_services.h>

#ifndef _MACRO_ONLY

/*
 *  ꥢݡȤν֥å
 */

typedef struct sio_port_initialization_block {
	UW	base;		/* SCI Υ١ɥ쥹	*/
	UW	baudrate;	/* ܡ졼		*/	
	IRC	irc;		/* ߥ٥ */
	UB	smr_init;	/* SMR 		*/
} SIOPINIB;

/*
 *  ꥢݡȤ֥å
 */

typedef struct sio_port_control_block {
	const SIOPINIB	*inib;		/* ֥å	*/
	VP_INT		exinf;		/* ĥ		*/
	BOOL		openflag;	/* ץѤߥե饰	*/
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ֥åؤѴޥ
 */

#define INDEX_SIO(sioid)	((UINT)((sioid) - 1))
#define get_siopcb(sioid)	(&(siopcb_table[INDEX_SIO(sioid)]))

/*
 *  Хå롼μֹ
 */

#define SIO_ERDY_SND		1u			/* ǽХå			*/
#define SIO_ERDY_RCV		2u			/* ΥХå			*/

/*
 *  SCI ؿλ
 */

extern void	SCI_initialize (ID sioid);		/* SCI ν				*/
extern void	SCI_cls_por(UW base);			/* SCI Υ			*/
extern void	SCI_in_handler(ID sioid);		/* SCI ϳߥϥɥ		*/
extern void	SCI_out_handler(ID sioid);		/* SCI ϳߥϥɥ		*/
extern void	SCI_err_handler(ID sioid);		/* SCI ϥ顼ߥϥɥ		*/
extern void	SCI_ierdy_snd(VP_INT exinf);		/* ꥢ I/O ǽХå	*/
extern void	SCI_ierdy_rcv(VP_INT exinf);		/* ꥢ I/O μΥХå	*/

/*
 *  SCI ٥δؿ
 */

/*
 *  SCI Υץ
 */

Inline SIOPCB *
SCI_opn_por (ID sioid)
{
	SCI_initialize(sioid);
	return get_siopcb(sioid);
}

/*
 *  SCI_putchar -- ʸν񤭹
 */

Inline void
SCI_putchar(SIOPCB *p, UB c)
{
	UW addr = p->inib->base + H8SSR;

	sil_wrb_mem((VP)(p->inib->base + H8TDR), c);
	bitclr((UB *)addr, H8SSR_TDRE_BIT);
}

/*
 *  SCI_wait_putchar -- ľܽ (Ԥ)
 */

Inline void
SCI_wait_putchar (int base, char c)
{
	UW addr = base + H8SSR;

	/* TDRE  1 ˤʤޤԤ */
	while ((sil_reb_mem((VP)addr) & H8SSR_TDRE) == 0)
		;
	sil_wrb_mem((VP)(base + H8TDR), c);
	bitclr((UB *)addr, H8SSR_TDRE_BIT);
}

/*
 *  SCI_getchar -- ʸɤ߽Ф
 */

Inline INT
SCI_getchar(SIOPCB *p)
{
	INT	ch;
	UW	addr = p->inib->base + H8SSR;

	ch = (INT)(UB)sil_reb_mem((VP)(p->inib->base + H8RDR));
	/*  UBؤΥ㥹Ȥϡĥɤ  */

	bitclr((UB *)addr, H8SSR_RDRF_BIT);
	return ch;
}

/*
 *  SCI_putready -- ǽ
 */

Inline BOOL
SCI_putready(SIOPCB *pcb)
{
	UB ssr = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
	return ((ssr & H8SSR_TDRE) != 0);
}

/*
 *  SCI_getready -- ǽ
 */

Inline BOOL
SCI_getready(SIOPCB *pcb)
{
#ifndef HEW_SIMULATOR
	UB ssr = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
	return ((ssr & H8SSR_RDRF) != 0);
#else /* HEW_SIMULATOR */
	return TRUE;
#endif /* HEW_SIMULATOR */
}

/*
 *  ؿ
 */

Inline void
SCI_enable_send(SIOPCB *p)
{
	UW addr = p->inib->base + H8SCR;
	
	bitset((UB *)addr, H8SCR_TIE_BIT);
}

Inline void
SCI_disable_send(SIOPCB *p)
{
	UW addr = p->inib->base + H8SCR;

	bitclr((UB *)addr, H8SCR_TIE_BIT);
}

/*
 *  ؿ
 */

Inline void
SCI_enable_recv(SIOPCB *p)
{
	UW addr = p->inib->base + H8SCR;

	bitset((UB *)addr, H8SCR_RIE_BIT);
}

Inline void
SCI_disable_recv(SIOPCB *p)
{
	UW addr = p->inib->base + H8SCR;

	bitclr((UB *)addr, H8SCR_RIE_BIT);
}

/*
 *  SIO ؿλ
 */

extern void	sio_initialize(void);			/* SCI ν				*/
extern void	sio_ena_cbr(SIOPCB *pcb, UINT cbrtn);	/* ꥢ I/O ΥХå	*/
extern void	sio_dis_cbr(SIOPCB *pcb, UINT cbrtn);	/* ꥢ I/O ΥХåػ	*/

/*
 *  ؿߥ졼ޥ
 */
												/* SCI ʸ			*/
#ifdef HEW_SIMULATOR
extern BOOL hew_io_sim_snd_chr(char c);
#define sio_snd_chr(siopcb, c) hew_io_sim_snd_chr(c)

#else	/* HEW_SIMULATOR */
#define sio_snd_chr(p,c)	SCI_snd_chr(p,c)
#endif	/* HEW_SIMULATOR */
												/* SCI ʸ			*/
#ifdef HEW_SIMULATOR
extern INT hew_io_sim_rcv_chr(void);
#define sio_rcv_chr(siopcb) hew_io_sim_rcv_chr( )

#else	/* HEW_SIMULATOR */
#define sio_rcv_chr(p)		SCI_rcv_chr(p)
#endif	/* HEW_SIMULATOR */

#define sio_ierdy_snd(e)	SCI_ierdy_snd(e)	/* ꥢ I/O ǽХå	*/
#define sio_ierdy_rcv(e)	SCI_ierdy_rcv(e)	/* ꥢ I/O μΥХå	*/

/*
 *  SIO ٥δؿ
 */

/*
 *  sio_opn_por -- ݡȤΥץ
 */

Inline SIOPCB *
sio_opn_por(ID sioid, VP_INT exinf)
{
	SIOPCB	*pcb;

	pcb = SCI_opn_por(sioid);
	pcb->exinf    = exinf;
	pcb->openflag = TRUE;
	return pcb;
}

/*
 *  sio_cls_por -- ݡȤΥ
 */

Inline void
sio_cls_por(SIOPCB *pcb)
{
	SCI_cls_por(pcb->inib->base);
	pcb->openflag = FALSE;
}

/*
 *  sio_snd_chr -- ʸ
 */

#ifndef HEW_SIMULATOR
Inline BOOL
sio_snd_chr(SIOPCB *pcb, INT chr)
{
	if (SCI_putready(pcb)) {
		SCI_putchar(pcb, (UB)chr);
		return TRUE;
	} else {
		return FALSE;
	}
}
#endif	/* HEW_SIMULATOR */

/*
 *  sio_rcv_chr -- ʸ
 */

#ifndef HEW_SIMULATOR
Inline INT
sio_rcv_chr(SIOPCB *pcb)
{
	if (SCI_getready(pcb)) {
		return SCI_getchar(pcb);
	} else {
		return -1;
	}
}
#endif	/* HEW_SIMULATOR */

#endif	/* of #ifndef _MACRO_ONLY */

#endif /* _HW_SERIAL_H_ */
