/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2010 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.15 2007/03/23 07:22:15 honda Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <h8_sil.h>

#ifndef _MACRO_ONLY

/*
 *  CPU¸ޥ⥸塼H8ѡ
 */

/*
 *  ͤɽη
 */

typedef UH	CLOCK;

/*
 *  ޼ñ̤ɽѴ
 *  	jsp/kernel/time_manage.cǤ
 */

#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)

/*
 *  ޼ñ̤ɽѴ
 */

#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */

#define MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ǽɾѥƥФݤν֤θѤ
 *	ñ̤ɽ
 *	աʬå˰¸
 */

#define GET_TOLERANCE	100
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ץ饤ƥ٥ѤΥǡ
 *      ϳߥȥ¸ʬʬΥ٤
 *
 *      hw_timer.h˼Τ򵭽Ҥ٤
 *      hw_timer.h򥤥󥯥롼ɤեǤ٤Ƽβ
 *ΰͭƤޤᡢΤcpu_config.c˵Ҥ롣
 */
extern const IRC TIMER_IRC;

/*
 *  ޳׵Υꥢ
 *	TCR쥸IMFAӥåȤ1ɤ߽Фˣ񤭹
 */

Inline void
hw_timer_int_clear(void)
{
    /* GRAڥޥåγ׵ե饰򥯥ꥢ */
    bitclr((UB *)SYSTEM_TIMER_IFR, SYSTEM_TIMER_IF_BIT);
}

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */

Inline void
hw_timer_initialize(void)
{
    /*  */
    bitclr((UB *)SYSTEM_TIMER_TSTR, SYSTEM_TIMER_STR_BIT);

    /*  GRAڥޥåǥ󥿤򥯥ꥢʬ */
    sil_wrb_mem((VP)SYSTEM_TIMER_TCR, SYSTEM_TIMER_TCR_BIT);

    /*  GRAڥޥåˤ׵ */
    bitset((UB *)SYSTEM_TIMER_IER, SYSTEM_TIMER_IE_BIT);

    /*  GRAڥޥåˤüҽ϶ػ */
    sil_wrb_mem((VP)SYSTEM_TIMER_TIOR, SYSTEM_TIMER_TIOR_BIT);

    /*  GRA쥸ʥɸ͡  	*/
    sil_wrh_mem((VP)SYSTEM_TIMER_GR, CLOCK_PER_TICK);

    sil_wrh_mem((VP)SYSTEM_TIMER_CNT, 0);	/* 󥿤򥯥ꥢ	*/

    hw_timer_int_clear();			/*  ׵򥯥ꥢ	*/

    /*
     *  ץ饤ƥ٥
     *  ϳߥȥ¸ʬʬΥ٤
     */
    define_int_plevel(&TIMER_IRC);

    /* ޥ */
    bitset((UB *)SYSTEM_TIMER_TSTR, SYSTEM_TIMER_STR_BIT);
}

/*
 *  ޤ߽
 */

Inline void
hw_timer_terminate(void)
{
    					/*  */
    bitclr((UB *)SYSTEM_TIMER_TSTR, SYSTEM_TIMER_STR_BIT);
    hw_timer_int_clear();		/* ׵򥯥ꥢ */
}

/*
 *  ޤθͤɤ߽Ф
 *
 *  ߶ػ߶ǸƤӽФȡ
 */

Inline CLOCK
hw_timer_get_current(void)
{
	return((CLOCK)(sil_reh_mem((VP)SYSTEM_TIMER_CNT)));
}

/*
 *  ޳׵Υå
 */

Inline BOOL
hw_timer_fetch_interrupt(void)
{
	UB ifr = sil_reb_mem((VP)SYSTEM_TIMER_IFR);
	return(ifr & SYSTEM_TIMER_IF);
}

#endif	/* of #ifndef _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
