/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  ץå˰¸H8Sѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#define H8S

/* ͥ뵯ưΥå */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2007 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n" \
"Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering,\n" \
"                 Tomakomai National College of Technology, JAPAN\n"

#ifndef _MACRO_ONLY

/*
 *  ߡCPU㳰ϥɥֹη
 */
typedef	UINT	INHNO;			/* ߥϥɥֹ */
typedef	UINT	EXCNO;			/* CPU㳰ϥɥֹ */

/*
 *  ߥޥηȳߥޥѹ
 */

/* ߥޥη */
typedef	UB	IPM;			/* ߥޥ */

/* ߥޥѤδؿ */
extern ER	chg_ipm(IPM ipm) throw();	/* ߥޥѹ */
extern ER	get_ipm(IPM *p_ipm) throw();	/* ߥޥμ */

#if 0		/*  ǤϥݡȤƤʤ  */
/*
 *  INTNOȳߤζػ/
 */
typedef	UINT	INTNO;			/* ֹ */

extern ER	dis_int(INTNO intno) throw();
extern ER	ena_int(INTNO intno) throw();
#endif


/*
 *ƥ।󥿥ե쥤
 */

/*
 *  ߥå֤
 */
#define	SIL_PRE_LOC	IPM _intmask_ = current_intmask()
#define	SIL_LOC_INT()	_disint_()
#define	SIL_UNL_INT()	set_intmask(_intmask_)

/*
 * Ԥ
 * ջࡧ
 * ɸǤdlytimUINT16ӥåȤʤΤǡ
 * sil_dly_nse_long()ǤϰUWѹƤ롣
 * sil_dly_nse()sil_dly_nse_long()ƤӽФ
 * 
 * sil_dly_nse()Υץȥjsp/include/sil.hˤ롣
 */
extern void sil_dly_nse_long(UW dlytim) throw();

/*
 *  ץåΥǥ
 */
#define	SIL_ENDIAN	SIL_ENDIAN_BIG		/* ӥåǥ */


/*
 *  ǥȿž
 */
#define	SIL_REV_ENDIAN_H(data) \
	((VH)((((UH)(data) & 0xff) << 8) | (((UH)(data) >> 8) & 0xff)))

#define	SIL_REV_ENDIAN_W(data) \
	((VW)((((UW)(data) & 0xff) << 24) | (((UW)(data) & 0xff00) << 8) \
		| (((UW)(data)>> 8) & 0xff00) | (((UW)(data) >> 24) & 0xff)))

/*
 *  ֥ؿ
 *  
 *  ѥηٹ򤹤뤿ᡢ¸ǥؿѰդ롣
 *  Ƥjsp/include/sil.hȤޤäƱ
 *  ֤Թ塢嵭Ρ֥ǥȿžפ֤äƤ롣
 */
#define OMIT_SIL_ACCESS

/*
 *  8ӥåñ̤ɽФ
 */
Inline VB
sil_reb_mem(VP mem)
{
	VB data = *((volatile VB *) mem);
	return(data);
}

Inline void
sil_wrb_mem(VP mem, VB data)
{
	*((volatile VB *) mem) = data;
}

/*
 *  16ӥåñ̤ɽФ
 */
Inline VH
sil_reh_mem(VP mem)
{
	VH data = *((volatile VH *) mem);
	return(data);
}

Inline void
sil_wrh_mem(VP mem, VH data)
{
	*((volatile VH *) mem) = data;
}

#define	sil_reh_bem(mem)	sil_reh_mem(mem)
#define	sil_wrh_bem(mem, data)	sil_wrh_mem(mem, data)

Inline VH
sil_reh_lem(VP mem)
{
	VH data = *((volatile VH *) mem);
	return(SIL_REV_ENDIAN_H(data));
}

Inline void
sil_wrh_lem(VP mem, VH data)
{
	*((volatile VH *) mem) = SIL_REV_ENDIAN_H(data);
}

/*
 *  32ӥåñ̤ɽФ
 */
Inline VW
sil_rew_mem(VP mem)
{
	VW data = *((volatile VW *) mem);
	return(data);
}

Inline void
sil_wrw_mem(VP mem, VW data)
{
	*((volatile VW *) mem) = data;
}

#define	sil_rew_bem(mem)	sil_rew_mem(mem)
#define	sil_wrw_bem(mem, data)	sil_wrw_mem(mem, data)

Inline VW
sil_rew_lem(VP mem)
{
	VW data= *((volatile VW *) mem);
	return(SIL_REV_ENDIAN_W(data));
}

Inline void
sil_wrw_lem(VP mem, VW data)
{
	*((volatile VW *) mem) = SIL_REV_ENDIAN_W(data);
}

/*
 *I/OݡȤΥǡǥ쥯󡦥쥸DDRؤΥ
 */

/*  ݡֹ  */
typedef enum  {
	IO_PORT1,
	IO_PORT2,
	IO_PORT3,
	IO_PORT5,	/*  ݡȣDDRϤʤ  */
	IO_PORT6,
	IO_PORT7,
	IO_PORT8,
	IO_PORT9,
	IO_PORTA,
	IO_PORTB,
	IO_PORTC,
	IO_PORTD,
	IO_PORTE,
	IO_PORTF,
	IO_PORTG
} IO_PORT_ID;

extern UB sil_reb_ddr(IO_PORT_ID port) throw();
extern void sil_wrb_ddr(IO_PORT_ID port, UB data) throw();
extern void sil_anb_ddr(IO_PORT_ID port, UB data) throw();
extern void sil_orb_ddr(IO_PORT_ID port, UB data) throw();


/*============================================================================*/
/*  ǥХåѥ  */

#ifdef TEST_CPU_INSN
extern void test_cpu_insn(void);
#endif /* TEST_CPU_INSN */

#ifdef TEST_CPU_CONFIG
extern void test_cpu_config(void);
#endif /* TEST_CPU_CONFIG */

#ifdef TEST_H8S_SIL
extern void test_h8s_sil(void);
#endif /* TEST_H8S_SIL */

/*============================================================================*/



#endif /* _MACRO_ONLY */

#endif /* _CPU_DEFS_H_ */
