/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: h8s_sil.c,v 1.2 2007/03/23 07:59:26 honda Exp $
 */

/*
 * ƥ।󥿥ե쥤ɲʬ
 *I/OݡȤΥǡǥ쥯󡦥쥸DDRؤΥ
 *H8SDDRϽ񤭹ѤǤꡢΤޤޤǤϽ˾ΥӥåȤ
 *ѹ뤳ȤǤʤbset,bclr̿ǤԲġ
 *ΤᡢܼǤϡ˥ƥݥѰդơDDR
 *ͤݻˡΤäƤ롣
 *
 *ݡȣDDRϤʤᡢ֤ˤƤ롣
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*  Υƥݥΰ  */
static UB ddr_tmp[] = {
        P1DDR0, P2DDR0, P3DDR0, P5DDR0, 	/*  ݡȣϷ  */
        P6DDR0, P7DDR0, P8DDR0, P9DDR0, 
        PADDR0, PBDDR0, PCDDR0, PDDDR0, PEDDR0, 
        PFDDR0, PGDDR0
};

/*  
 *ƥݡȤΥɥ쥹  
 *ɥ쥹β16ӥåȤݻ롣
 */
static const UH ddr_adr[] = {
        P1DDR, P2DDR, P3DDR, P5DDR,  		/*  ݡȣϷ  */
        P6DDR, P7DDR, P8DDR, P9DDR, 
        PADDR, PBDDR, PCDDR, PDDDR, PEDDR,
        PFDDR, PGDDR
};


/*
 *      DDRɤ߽Ф
 */
UB sil_reb_ddr(IO_PORT_ID port)
{
	assert(port <= TNUM_IO_PORT);
	return ddr_tmp[port];
}

/*
 *      DDRν񤭹
 */
void sil_wrb_ddr(IO_PORT_ID port, UB data)
{
	assert(port <= TNUM_IO_PORT);
	ddr_tmp[port] = data;
	h8s_wrb_reg(ddr_adr[port], (VB)data);
}

/*
 *      DDRAND黻
 */
void sil_anb_ddr(IO_PORT_ID port, UB data)
{
	UB ddr = sil_reb_ddr(port);
        
	ddr &= data;
	sil_wrb_ddr(port, ddr);
}

/*
 *      DDROR黻
 */
void sil_orb_ddr(IO_PORT_ID port, UB data)
{
	UB ddr = sil_reb_ddr(port);

	ddr |= data;
	sil_wrb_ddr(port, ddr);
}

