/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _MISPO_H8S_2350_H_
#define _MISPO_H8S_2350_H_

/*
 *  MISPO H8S/2350 ɾܡ
 */

#define MISPO_H8S_2350

/*
 *  CPU å
 */
#define CPU_CLOCK	20000			/* kHz = 20MHz*/

/*
 *  ޤ˶뤵륯å (å/4ǥ)
 */
#define TIMER_CLOCK	((CPU_CLOCK)/4)		/* 20MHz / 4 = 5MHz = 5000kHz */

/*
 *  ݡȣѥޥ
 *    sys_support.SǡݡȣꤹΤѤ롣
 *    ΥݡȤˤϡLED³ƤΤǡƽꤹ롣
 */
#define	PORT2_INIT								\
	mov.l	#(H8S_BASE_ADDR + P2DDR), er0					\
	mov.b	#(P27DDR|P26DDR|P25DDR|P24DDR|P23DDR|P22DDR|P21DDR|P20DDR), r1l	\
	mov.b	r1l, @er0

/*
 *  DIPåLEDѥޥ
 */
#define dipsw_read()	h8s_reb_mem( (VP) P1DR )

#define led_read()	h8s_reb_mem( (VP) P2DR )
#define led_write(c)	h8s_wrb_mem( (VP) P2DR, c )

#endif /* _MISPO_H8S_2350_H_ */
