/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY
#include <jsp_kernel.h>

/*
 *  åȥϡɥ¸
 */
	.h8300s
	.text
	.align 2

	.global	_hardware_init_hook

_hardware_init_hook:

#ifndef GDB_STUB	/* ROM νʤɤϡGDB ֤ǹԤΤ */
	/*
	 *  SYSCR 
	 *  ⡼ɤ⡼2
	 *  ¢RAM̵
	 */
	mov.l	#(H8S_BASE_ADDR+SYSCR), er0
	mov.b	@er0, r1l		/* r1l = SYSCR */

	or.b	#INTM1, r1l		/* INTM1 = 1(⡼2) */
	bset	#RAME_BIT, r1l		/* RAME  = 1(¢RAMͭ) */
	mov.b	r1l, @er0		/* SYSCR = r1l */

	/*
	 *  MCU ư⡼ɤ
	 *  ܡɾΥǥåץåǥ⡼5
	 *    (⡼5ɥХ󥹥ȡ¢ROM̵ĥ⡼ɡɥ쥹֤16MB)
	 *  MCU ư⡼ɤˤꡢI/OݡȤϰʲΤ褦ꤵ롣
         *      ݡA, B, Cɥ쥹
         *      ݡD      ǡ
         *      ݡF      PF6PF3 -> Х
	 */

	/*
	 * I/O ݡȤν (DRAM󥿥եط)
	 */
	mov.l	#(H8S_BASE_ADDR+PGDDR), er0	/* ݡȣ  */
	mov.b	#(PG4DDR|PG3DDR), r1l		/* ⡼ɣǤѤʤΤǡ
						   CS0,CS1 ֥͡ */
	mov.b	r1l, @er0

        /*
         *  Хȥ
         *  ROM (0x000000-0x01ffff;128kB)ꥢ0
         *  RAM (0x200000-0x21ffff:128kB)ꥢ1
         *  ¢RAM (0xfff400-0xfffbff:  2kB)
	 *  I/O (0xfffe3f-0xffffff:     )ꥢ7
         *
	 *  
	 *  ꥢ0 16ӥåȥ		( ABW0=1 ; ABWCR )
	 *		3ơȥ		( AST0=1 ; ASTCR )
	 *		ץ०Ȥ3ơ
	 *						( W01=1, W00=1 ; WCRL )
	 *  ꥢ1 16ӥåȥ		( ABW1=1 ; ABWCR )
	 *		3ơȥ		( AST1=1 ; ASTCR )
	 *		ץ०Ȥ3ơ
	 *						( W11=1, W10=1 ; WCRL )
	 *  ɥ륵
	 *	      ۤʤ륨ꥢγ꡼ɥ뤬Ϣ³Ȥ,
	 *		  ɥ륵	( ICIS1=1 ; BCRH )
	 *	      ꡼ɥȳ饤ȥ뤬Ϣ³Ȥ,
	 *		  ɥ륵	( ICIS0=1 ; BCRH )
	 *	      Сȥϣơ	( BRSTS1=1; BCRH )
         *  ( ա¢RAMڤ¢I/O쥸Ф륢ơȿ
         *          ASTCRͤ˴ؤ餺ꡣ)
	 */

	/* ABWCR, ASTCR ϽͤΤޤޤʤΤǡά */

	/* ȥȥ쥸L (WCRL)  */
	mov.l	#(H8S_BASE_ADDR+WCRL), er0
	mov.b	#(W11|W10|W01|W00), r1l
	mov.b	r1l, @er0

	/* Хȥ쥸H (BCRH)  */
	mov.l	#(H8S_BASE_ADDR+BCRH), er0
 	mov.b	#(ICIS1|ICIS0|BRSTS1), r1l	/* 쥸ͤƱ */
	mov.b 	r1l, @er0

#endif /* GDB_STUB */

	/*
	 * I/O ݡȤν (¾)
	 */

	/* ݡȣ */
	/* ΥݡȤˤϡåȥܡɤǤϥǥåץå³Ƥ롣
	   P1DDR ϽͤǡϡפʤΤǡ */

	/* ݡȣ */
	/* ΥݡȤˤϡåȥܡɤǤ LED ³Ƥ롣
	   ޥϡåȥܡɤ˴ؤեƤ롣 */
	PORT2_INIT

	/* ݡȣ */
	/* ΥݡȤˤϡ¢SCI ³Ƥ롣
	   SCI  SCRSMRȤʤԤΤǡ */

	mov.l	@bss_clear_k, er0
	jmp	@er0

bss_clear_k:
	.long  bss_clear
