/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2002 by Monami software, Limited Partners.
 *  Copyright (C) 2008-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2004/07/21 02:49:36 monaka Exp $
 */

/*
 *	ץå¸⥸塼i386ѡ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */

/*
 *  TCB ΥեɤΥӥå
 */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_TWAIT		8	/* twait եɤΥӥå */

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	VP	esp;		/* åݥ */
	FP	eip;		/* ץ५ */
} CTXB;

/*
 *  ߤΥͥȲ
 *
 *  1ʾλ󥿥ƥȤˤʤ롣ߥϥɥ㳰ϥɥ
 *  ǥ󥯥ȡǥȤ롣
 */
extern UW nest;

/*
 *  ƥֻ
 */

Inline BOOL
sense_context()
{
	return (nest != 0);
}

Inline BOOL
sense_lock()
{
	unsigned _int32_ eflag;

	Asm("pushf");
	Asm("popl %0" : "=g"(eflag));

	return ((eflag & 0x200) == 0);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβ
 *
 */

Inline void x_lock_cpu(void) {
	disint();
	Asm("":::"memory");
}

#define i_lock_cpu() x_lock_cpu()
#define t_lock_cpu() x_lock_cpu()

Inline void x_unlock_cpu(void) {
	Asm("":::"memory");
	enaint();
}

#define i_unlock_cpu() x_unlock_cpu()
#define t_unlock_cpu() x_unlock_cpu()

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  CPU㳰ϥɥ
 */

/*
 *  㳰ϥɥνcpu_support.S
 */
extern void exception0(void);
extern void exception1(void);
extern void exception2(void);
extern void exception3(void);
extern void exception4(void);
extern void exception5(void);
extern void exception6(void);
extern void exception7(void);
extern void exception8(void);
extern void exception9(void);
extern void exception10(void);
extern void exception11(void);
extern void exception12(void);
extern void exception13(void);
extern void exception14(void);
extern void exception16(void);
extern void exception17(void);
extern void exception18(void);
extern void exception19(void);

/*
 *  CPU㳰ϥɥΥơ֥cpu_config.c
 *
 *  CPU㳰ϥɥϰöΥơ֥Ͽ졢̤Ѱդ줿
 *  ƤӽФ
 */
extern FP exc_table[0x20];

/*
 *  CPU㳰ϥɥ
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr 
 */
extern void define_exc(EXCNO excno, FP exchdr);

/*
 *  CPU㳰ϥɥν
 */

/*
 *  CPU㳰ϥɥνޥ
 */

#define EXCHDR_ENTRY(exchdr) extern void exchdr(VP p_excinf)

#define EXC_ENTRY(exchdr) exchdr

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȤλ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return (nest > 1);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return ((((UW *)p_excinf)[3] & 0x200) == 0);
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

/*
 * i386ȥǥץ
 */
extern void set_segment_descriptor(int sel, unsigned addr, unsigned limit, unsigned type, unsigned dpl);
extern void set_gate_descriptor(int sel, unsigned selector, void *func, unsigned type, unsigned dpl);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
