/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ 
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  (1)(4)ξ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: m3029.h,v 1.2 2006/08/03 04:14:02 honda Exp $
 */

#ifndef _M3029_H_
#define	_M3029_H_

/*
 *  ֹ
 */
#define	INT_BRK         0			/* BRK */
#define INT_INT3        4			/* INT3 */
#define INT_TB5	        5			/* B5 */
#define INT_TB4         6			/* B4 */
#define INT_TB3         7			/* B3 */
#define INT_SIO4INT5    8			/* SI/O4/INT5 */
#define INT_SIO3INT4    9			/* SI/O3/INT4 */
#define INT_BUS         10			/* Х͸ */
#define INT_DMA0        11			/* DMA0 */
#define INT_DMA1        12			/* DMA1 */
#define INT_KEY         13			/* ϳ */
#define INT_AD          14			/* -Ѵ */
#define INT_S2TNACK     15			/* UART2,NACK2 */
#define INT_S2RACK      16			/* UART2,ACK2 */
#define INT_S0T         17			/* UART0 */
#define INT_S0R         18			/* UART0 */
#define INT_S1T         19			/* UART1 */
#define INT_S1R         20			/* UART1 */
#define INT_TA0         21			/* A0 */
#define INT_TA1         22			/* A1 */
#define INT_TA2         23			/* A2 */
#define INT_TA3         24			/* A3 */
#define INT_TA4         25			/* A4 */
#define INT_TB0         26			/* B0 */
#define INT_TB1         27			/* B1 */
#define INT_TB2         28			/* B2 */
#define INT_INT0        29			/* INT0 */
#define INT_INT1        30			/* INT1 */
#define INT_INT2        31			/* INT2 */

/*
 *  M3029 SFRɥ쥹
 *
 *  ߥ쥸
 */
#define	TADR_SFR_INT_BASE       0x040			/* ߴϢΥ١ɥ쥹 */
#define TADR_SFR_INT3IC_OFFSET  4				/* INT3 쥸 */
#define TADR_SFR_TB5IC_OFFSET   5				/* timerB5 쥸 */
#define TADR_SFR_TB4IC_OFFSET   6				/* timerB4 쥸 */
#define TADR_SFR_TB3IC_OFFSET   7				/* timerB3 쥸 */
#define TADR_SFR_SO4INT5_OFFSET 8				/* SI/O4/INT5 쥸 */
#define TADR_SFR_SO3INT4_OFFSET 9				/* SI/O3/INT4 쥸 */
#define TADR_SFR_BCNIC_OFFSET   10				/* Х͸г쥸 */
#define TADR_SFR_DMA0IC_OFFSET  11				/* DMA0쥸 */
#define TADR_SFR_DMA1IC_OFFSET  12				/* DMA1쥸 */
#define TADR_SFR_KUPIC_OFFSET   13				/* ϳ쥸 */
#define TADR_SFR_ADIC_OFFSET    14				/* A-DѴ쥸 */
#define	TADR_SFR_S2TIC_OFFSET   15				/* uart2쥸 */
#define	TADR_SFR_S2RIC_OFFSET   16				/* uart2쥸 */
#define	TADR_SFR_S0TIC_OFFSET   17				/* uart0쥸 */
#define	TADR_SFR_S0RIC_OFFSET   18				/* uart0쥸 */
#define	TADR_SFR_S1TIC_OFFSET   19				/* uart1쥸 */
#define	TADR_SFR_S1RIC_OFFSET   20				/* uart1쥸 */
#define	TADR_SFR_TA0IC_OFFSET   21				/* timerA0 쥸 */
#define TADR_SFR_TA1IC_OFFSET   22				/* timerA1 쥸 */
#define TADR_SFR_TA2IC_OFFSET   23				/* timerA2 쥸 */
#define TADR_SFR_TA3IC_OFFSET   24				/* timerA3 쥸 */
#define TADR_SFR_TA4IC_OFFSET   25				/* timerA4 쥸 */
#define TADR_SFR_TB0IC_OFFSET   26				/* timerB0 쥸 */
#define TADR_SFR_TB1IC_OFFSET   27				/* timerB1 쥸 */
#define TADR_SFR_TB2IC_OFFSET   28				/* timerB2 쥸 */
#define TADR_SFR_INT0IC_OFFSET  29				/* INT0 쥸 */
#define TADR_SFR_INT1IC_OFFSET  30				/* INT1 쥸 */
#define TADR_SFR_INT12C_OFFSET  31				/* INT2 쥸 */

/*
 *  DMA쥸
 */
#define TADR_SFR_SAR0           0x020			/* DMA0ݥ */
#define TADR_SFR_DAR0           0x024			/* DMA0ǥƥ͡ݥ */
#define TADR_SFR_TCR0			0x028			/* DMA0ž */
#define TADR_SFR_DM0CON         0x02c			/* DMA0쥸 */
#define TADR_SFR_SAR1           0x030			/* DMA1ݥ */
#define TADR_SFR_DAR1           0x034			/* DMA1ǥƥ͡ݥ */
#define TADR_SFR_TCR1			0x038			/* DMA1ž */
#define TADR_SFR_DM1CON         0x03c			/* DMA1쥸 */

/*
 *  ޡȤ¾ΥǥХ쥸
 */
#define TADR_SFR_TA11           0x342			/* timerA1-1쥸 */
#define TADR_SFR_TA21           0x344			/* timerA2-1쥸 */
#define TADR_SFR_TA41           0x346			/* timerA4-1쥸 */
#define TADR_SFR_INVC0          0x348			/* PWM쥸 */
#define TADR_SFR_INVC1          0x349			/* PWM쥸 */
#define TADR_SFR_IDB0           0x34a			/* ϥХåե쥸 */
#define TADR_SFR_IDB1           0x34b			/* ϥХåե쥸 */
#define TADR_SFR_DTT            0x34c			/* ûɻߥ */
#define TADR_SFR_ICTB2          0x34d			/* timerB2ȯꥫ */

#define TADR_SFR_IFSR           0x35f			/* װ쥸 */

#define TADR_SFR_S3TRR          0x360			/* SI/O3쥸 */
#define TADR_SFR_S3C            0x362			/* SI/O3쥸 */
#define TADR_SFR_S3BRG          0x363			/* SI/O3ž®٥쥸 */
#define TADR_SFR_S4TRR          0x364			/* SI/O4쥸 */
#define TADR_SFR_S4C            0x366			/* SI/O4쥸 */
#define TADR_SFR_S4BRG          0x367			/* SI/O4ž®٥쥸 */

#define	TADR_SFR_TABSR          0x380			/* ȳϥե饰 */
#define TADR_SFR_CPSRF          0x381			/* ꥻå ץꥹ ꥻåȥե饰 */
#define TADR_SFR_ONSF           0x382			/* 󥷥 ȥե饰 */
#define TADR_SFR_TRGSR          0x383			/* ȥꥬ쥯 쥸 */
#define	TADR_SFR_UDF            0x384			/* åץե饰 */
#define	TADR_SFR_TA0            0x386			/* timerA0쥸 */
#define TADR_SFR_TA1            0x388			/* timerA1쥸 */
#define TADR_SFR_TA2            0x38a			/* timerA2쥸 */
#define TADR_SFR_TA3            0x38c			/* timerA3쥸 */
#define TADR_SFR_TA4            0x38e			/* timerA4쥸 */
#define TADR_SFR_TB0            0x390			/* timerB0쥸 */
#define TADR_SFR_TB1            0x392			/* timerB1쥸 */
#define TADR_SFR_TB2            0x394			/* timerB2쥸 */
#define	TADR_SFR_TA0MR          0x396			/* timerA0⡼ɥ쥸 */
#define	TADR_SFR_TA1MR          0x397			/* timerA1⡼ɥ쥸 */
#define	TADR_SFR_TA2MR          0x398			/* timerA2⡼ɥ쥸 */
#define	TADR_SFR_TA3MR          0x399			/* timerA3⡼ɥ쥸 */
#define	TADR_SFR_TA4MR          0x39a			/* timerA4⡼ɥ쥸 */
#define	TADR_SFR_TB0MR          0x39b			/* timerB0⡼ɥ쥸 */
#define	TADR_SFR_TB1MR			0x39c			/* timerB1⡼ɥ쥸 */
#define	TADR_SFR_TB2MR          0x39d			/* timerB2⡼ɥ쥸 */
#define	TADR_SFR_TB2SR          0x39e			/* timerB2ڥ⡼ɥ쥸 */

/*
 *  ꥢ쥸
 */
#define	TADR_SFR_UART0_BASE     0x3a0			/* uart0쥸١ɥ쥹 */
#define	TADR_SFR_UART1_BASE     0x3a8			/* uart1쥸١ɥ쥹 */
#define	TADR_SFR_UART2_BASE     0x378			/* uart2쥸١ɥ쥹 */
#define	TADR_SFR_U2SMR          0x377			/* uart2ü⡼ɥ쥸 */
#define	TADR_SFR_U2SMR2         0x376			/* uart2ü⡼ɥ쥸 */
#define	TADR_SFR_U2SMR3         0x375			/* uart2ü⡼ɥ쥸 */

#define	TADR_SFR_UMR_OFFSET     0				/* uart⡼ɥ쥸 */
#define	TADR_SFR_UBRG_OFFSET    1				/* uartܡ졼ȥͥ졼 */
#define	TADR_SFR_UTB_OFFSET     2				/* uartХåե쥸 */
#define	TADR_SFR_UC0_OFFSET     4				/* uart쥸#0 */
#define	TADR_SFR_UC1_OFFSET     5				/* uart쥸#1 */
#define	TADR_SFR_URB_OFFSET     6				/* uartХåե쥸 */
#define	TADR_SFR_UC2_OFFSET     16				/* uart쥸#2 */

/*
 *  A-D/D-A쥸
 */
#define TADR_SFR_AD0            0x3c0			/* A-D쥸 */
#define TADR_SFR_AD1            0x3c2			/* A-D쥸 */
#define TADR_SFR_AD2            0x3c4			/* A-D쥸 */
#define TADR_SFR_AD3            0x3c6			/* A-D쥸 */
#define TADR_SFR_AD4            0x3c8			/* A-D쥸 */
#define TADR_SFR_AD5            0x3ca			/* A-D쥸 */
#define TADR_SFR_AD6            0x3cc			/* A-D쥸 */
#define TADR_SFR_AD7            0x3ce			/* A-D쥸 */
#define TADR_SFR_ADCON2         0x3d4			/* A-D쥸 */
#define TADR_SFR_ADCON0         0x3d6			/* A-D쥸 */
#define TADR_SFR_ADCON1         0x3d7			/* A-D쥸 */
#define TADR_SFR_DA0            0x3d8			/* D-A쥸 */
#define TADR_SFR_DA1            0x3da			/* D-A쥸 */
#define TADR_SFR_DACON          0x3dc			/* D-A쥸 */

/*
 *  ѥݡȥ쥸
 */
#define TADR_SFR_P0             0x3e0           /* ݡP0쥸 */
#define TADR_SFR_P1             0x3e1           /* ݡP1쥸 */
#define TADR_SFR_PD0            0x3e2			/* ݡP0쥸 */
#define TADR_SFR_PD1            0x3e3			/* ݡP1쥸 */
#define TADR_SFR_P2             0x3e4			/* ݡP2쥸 */
#define TADR_SFR_P3             0x3e5			/* ݡP3쥸 */
#define	TADR_SFR_PD2            0x3e6			/* ݡP2쥸 */
#define	TADR_SFR_PD3            0x3e7			/* ݡP3쥸 */
#define TADR_SFR_P4             0x3e8			/* ݡP4쥸 */
#define	TADR_SFR_P5             0x3e9			/* ݡP5쥸 */
#define	TADR_SFR_PD4            0x3ea			/* ݡP4쥸 */
#define	TADR_SFR_PD5            0x3eb			/* ݡP5쥸 */
#define TADR_SFR_P6             0x3ec			/* ݡP6쥸 */
#define	TADR_SFR_P7             0x3ed			/* ݡP7쥸 */
#define	TADR_SFR_PD6            0x3ee			/* ݡP6쥸 */
#define	TADR_SFR_PD7            0x3ef			/* ݡP7쥸 */
#define	TADR_SFR_P8             0x3f0			/* ݡP8쥸 */
#define TADR_SFR_P9             0x3f1			/* ݡP9쥸 */
#define	TADR_SFR_PD8            0x3f2			/* ݡP8쥸 */
#define TADR_SFR_PD9            0x3f3			/* ݡP9쥸 */
#define TADR_SFR_P10            0x3f4			/* ݡP10쥸 */
#define TADR_SFR_PD10           0x3f6			/* ݡP10쥸 */
#define	TADR_SFR_PUR0           0x3fc			/* ץ륢å쥸 */
#define	TADR_SFR_PUR1           0x3fd			/* ץ륢å쥸 */
#define	TADR_SFR_PUR2           0x3fe			/* ץ륢å쥸 */
#define	TADR_SFR_PCR            0x3ff			/* ݡ쥸 */



/*
 * 쥸Υӥå
 */
#define	TBIT_IC_IR	0x08

/*
 *  쥸1Υӥå (UART0,UART1)
 */
#define	TBIT_UiC1_RI	0x08	/* λե饰 */
#define	TBIT_UiC1_RE	0x04	/* ĥӥå */
#define	TBIT_UiC1_TI	0x02	/* Хåեե饰 */
#define	TBIT_UiC1_TE	0x01	/* ĥӥå */

#define TBIT_UiC0_TXEPT	0x08	/* 쥸ե饰 */


/*
 *  ޡϢΥ쥸Υӥå
 */

/*
 *  ȳϥե饰 (TABSR)
 */
#define TBIT_TABSR_TA0S	0x01
#define TBIT_TABSR_TA1S	0x02
#define TBIT_TABSR_TA2S	0x04
#define TBIT_TABSR_TA3S	0x08
#define TBIT_TABSR_TA4S	0x10

/*
 *  åץե饰(UDF)
 */
#define TBIT_UDF_TA0UD	0x01
#define TBIT_UDF_TA1UD	0x02
#define TBIT_UDF_TA2UD	0x04
#define TBIT_UDF_TA3UD	0x08
#define TBIT_UDF_TA4UD	0x10


/*
 *  ץƥȥ쥸
 */
#define TADR_SFR_PRCR       0x00A

#define TVAL_PACR_PRCR      0x04   /* PACR񤭹ͭ */


/*
 * üҳ쥸  
 */
#define TADR_SFR_PACR       0x25D
#define TVAL_80_PACR        0x03   /* 80ԥ*/
#define TVAL_64_PACR        0x02   /* 64ԥ*/


#ifndef _MACRO_ONLY

#include "cpu_defs.h"

/*
 *  åȥƥʸ
 */

Inline void
m3029_putc(char c)
{
#if CONSOLE_PORTID == 1
	volatile char * p = (volatile char *)TADR_SFR_UART0_BASE;
#else	/* CONSOLE_PORTID == 2 */
	volatile char * p = (volatile char *)TADR_SFR_UART1_BASE;
#endif
	
	while((p[TADR_SFR_UC1_OFFSET] & TBIT_UiC1_TI) == 0);
	p[TADR_SFR_UTB_OFFSET] = c;
}

#endif /* _MACRO_ONLY */
#endif /* _M3029_H_ */

