/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.4 2003/12/11 00:58:01 honda Exp $
 */

/*
 *  ץå¸⥸塼Microblazeѡ
 */
#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <microblaze.h>


/*
 * ߥϥɥ/ӥåȥޥΥơ֥
 */
FP  int_handler_table[32];
UW  int_bit_table[32];

/*
 * CPU㳰ϥɥεơ֥
 * Not Support!
 */
/* FP	exc_table[(0x1E0 >> 5) + 1]; */


/*
 * ߤΥͥȲΥ
 * ͥ뵯ưϥΩȤߤʤ1ǽ
 */
UW interrupt_count = 1;

/*
 *  ץå¸ν
 */
void
cpu_initialize()
{
  int i;
    
  /*
   * int_handler_table[],int_plevel_table[]ν
   * ̤Ͽγȯcpu_interrup()ƤӽФ褦
   * no_reg_interrup()Ͽ
   */
  for(i = 0; i < 32; i++){
    int_handler_table[i] = no_reg_interrupt;
    int_bit_table[i]  = 1 << i; /* ӥåȥѥ */
  }
  
  /*
   *  INTC
   */
  intc_start();
}



/*
 *  ץå¸νλ
 */
void
cpu_terminate()
{
}


/*
 * ϿƤʤ㳰ȯȸƤӽФ
 * Not Support! 
 */
/*
void
cpu_expevt(void)
{
}
*/

/*
 * ̤Ͽγߤȯ˸ƤӽФ
 * Not Yet!
 */
void
cpu_interrupt(void)
{
    syslog(LOG_EMERG, "Unregisted Interrupt Occur!");

    while(1);
}
