/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

#include <mips3.h>

#ifndef _MACRO_ONLY

/*
 *  ơ쥸ؿ
 */

/* ơ쥸SRˤθͤɽФ */
Inline UW current_sr(void) {

	UW	sr;

	Asm( "mfc0 %0, "str_Status : "=r"(sr) );

	return( sr );
}


/* ơ쥸SRˤθͤѹ */
Inline void set_sr(UW sr) {

	Asm( "mtc0 %0, "str_Status : : "r"(sr) );
}


/* NMI٤Ƥγߤػ */
Inline void disint(void) {

	set_sr( (current_sr() & ~SR_IE) );
}


/* ߤ */
Inline void enaint() {

	set_sr( (current_sr() | SR_IE) );
}

/*
 *  ߥޥ饤֥MIPS3ѡ
 */

/* ߥޥ */
Inline void cpu_set_ipm(CORE_IPM intmask) {

	set_sr( (CORE_IPM) ((current_sr() & ~SR_IM) | intmask) );
}

/* ߥޥɽФ */
Inline CORE_IPM cpu_get_ipm() {

	return( (CORE_IPM)  (current_sr() &  SR_IM) );
}

#endif /* _MACRO_ONLY */
#endif /* _CPU_INSN_H_ */
