/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"
#include "offset.h"

	.section .text
	.align 2

	.set noat
		/* at쥸ѤȤ˥˥󥰤Ϥʤ褦 */
	.set noreorder

/*
 *  㳰/߽롼ʰ㳰
 *
 *  ͡
 *  CPU㳰ϥɥϡ󥿥ƥȤǼ¹Ԥ롣
 *  k0 쥸򡢳ߡ㳰ͥȥ󥿤ȤƻѤ롣
 *  reqflg å˳ߤػߤʤȡreqflg å˵ư
 *    줿ߥϥɥǥǥѥå׵ᤵ줿˥ǥѥåʤ
 *  ߵġԵĤνϡEXLӥåȤѤƹԤ
 *    ϡƽиΥƥȤ CPUå֤¸뤿Ǥ롣
 *    ˽ܹԤˤIEӥåȤѤơߵġԵ
 *    ¸ɬפ뤿ˡIEӥåȤˤߵġԵĤѹƤ
 *    ա
 *    㡧ٱǥѥåνľ㳰ƽФľ
 *
 *  C롼long longȤϥ쥸double wordǹ
 *  ٤٤㤤ΤȡΥСإåɤͤơword
 *  ԤäƤ롣Ūˤ򤹤ǡ򥿥°ǻǤ
 *  褦ˤͽ
 */

	.global general_exception
	.global join_interrupt_and_exception
		/* ؿƽ(proc_interrupt_sys)ɬ */

general_exception:
	addi    sp, sp, -25*4
	sw      sp,  0*4(sp)		/* EXCSTACK¤(cpu_experrؿ) */
	sw      at,  1*4(sp)
	sw      v0,  2*4(sp)
	sw      v1,  3*4(sp)
	sw      a0,  4*4(sp)
	sw      a1,  5*4(sp)
	sw      a2,  6*4(sp)
	sw      a3,  7*4(sp)
	sw      t0,  8*4(sp)
	sw      t1,  9*4(sp)
	sw      t2, 10*4(sp)
	sw      t3, 11*4(sp)
	sw      t4, 12*4(sp)
	sw      t5, 13*4(sp)
	sw      t6, 14*4(sp)
	sw      t7, 15*4(sp)
	sw      t8, 16*4(sp)
	sw      t9, 17*4(sp)
	sw      gp, 18*4(sp)
	sw      fp, 19*4(sp)
	sw      ra, 20*4(sp)

	mfc0    a1, Status		/* a1 -> 㳰ǻȤ */
	mfc0    t1, EPC

	sw      a1, 21*4(sp)		/* Status */
	sw      t1, 22*4(sp)		/* EPC */

	mfhi    t2			/* 쥸 HI  */
	mflo    t3			/* 쥸 LO  */

	sw      t2, 23*4(sp)		/* HI */
	sw      t3, 24*4(sp)		/* LO */

	move	a0, sp			/* 㳰ϥɥΰ */
		/* ϡ㳰ȯΥǡ򤷤åΰؤΥݥ
		   ߥȥΥǡޤʣˤʤ뤿ᡢ
		   оݤMIPS3Υ쥸ʬΤߤȤ롣 */

	PUSH_ICU_IPM			/* ߥȥγߥޥ
					   ޥ(ƥ¸) */

	bgtz    k0, multipul_exception  /*  ʤ㳰¿㳰Ƚ */
	addi    k0, k0, 1               /* ͥȥ󥿤Υ󥯥 */

/* ʤ㳰ξ */
first_exception:
	la      t3, _stack_top		/* _stack_top ϡƥ¸
					   (󥫥ץȿ侩) */
					/* åݥ󥿤θ(t3=t3-4)ϡ
					   _stack_top ˹ԤäƤΤǡ
					   Ǥ */
	sw      sp, (t3)		/* åݥ󥿤¸ */
	move    sp, t3			/* åڤؤ */

	jal     proc_interrupt_and_exception	/* ߤ㳰Ƚ̽ */
	nop

	/*  ߶ػߤäƤ  */
	la      t2, reqflg
	lw      t3, (t2)		/* t3 = reqflg */
	lw      sp, (sp)		/* åڤؤ */
	beq     t3, zero, ret_to_task_int	/* ǥѥå׵᤬ʤ */
	nop

	j       ret_int			/* ߡ㳰νи */
	sw      zero, (t2)		/* reqflg Υꥢ */

/* ¿㳰¿ųߡˤξ (㳰ϥɥΰϴ a0 Ѥ) */
multipul_exception:
	jal     proc_interrupt_and_exception	/* ߤ㳰Ƚ̽ */
	nop

/* ǥѥåƤФñ˳߸㳰ȯˤ */
ret_to_task_int:
	POP_ICU_IPM			/* ߥȥγߥޥ
					   ޥ(ƥ¸) */

	lw      t0, 23*4(sp)		/* HI */
	lw      t1, 24*4(sp)		/* LO */

	mthi    t0			/* 쥸 HI  */
	mtlo    t1			/* 쥸 LO  */

/*  αlong longѤ  */
	lw      t0, 21*4(sp)    	/* Status */
	lw      t1, 22*4(sp)		/* EPC */

	lw      at,  1*4(sp)
	lw      v0,  2*4(sp)
	lw      v1,  3*4(sp)
	lw      a0,  4*4(sp)
	lw      a1,  5*4(sp)
	lw      a2,  6*4(sp)
	lw      a3,  7*4(sp)

	/*
	 *  ¿㳰ʤΤǡåʤʤΤǡƥ
	 *  γߥޥѹƤ뿴ۤϤʤ
	 *  ʥơ쥸ϸͤ򤽤Τޤ޽᤹
	 */
	mtc0    t0, Status
	mtc0    t1, EPC

	lw      t0,  8*4(sp)
	lw      t1,  9*4(sp)
	lw      t2, 10*4(sp)
	lw      t3, 11*4(sp)
	lw      t4, 12*4(sp)
	lw      t5, 13*4(sp)
	lw      t6, 14*4(sp)
	lw      t7, 15*4(sp)
	lw      t8, 16*4(sp)
	lw      t9, 17*4(sp)
	lw      gp, 18*4(sp)
	lw      fp, 19*4(sp)
	lw      ra, 20*4(sp)

	addi    sp, sp, 25*4		/* ERET ̿ϡľ̿¹Ԥʤ
					   Τٱ䥹åȤˤʤ*/

	eret				/* 㳰 */
	nop

/*
 *  ߤ㳰Ƚ̽ؿ
 *    ʲΥ쥸ͤѤ
 *      a0 : 㳰ϥɥΰ, a1 : ơ쥸
 */
proc_interrupt_and_exception:
	addi    sp, sp, -4
	sw      ra, 0(sp)

	mfc0    a2, Cause
	andi    t2, a2, ExcCode_mask
	beq     t2, zero, proc_interrupt        /* ߤ㳰Ƚ */
		/* ľproc_interrupt_sysӤϤʤ
		   ǽΤǡproc_interrupt֡ */
	nop

/* ߰ʳ㳰ν */
	la      t4, exc_table
         	              		/* a1 = Status  */
	ori     t5, a1, SR_EXL
	xori    t5, t5, SR_EXL		/* EXLӥåȥꥢ */
		/* ߰ʳ㳰CPUå֤ǤդΤǡCPUå
		   ֤¸ɬפ롣ΤIEӥåȤˡ
		   ߶ػߡĤEXLӥåȤѤƼ¸ */
	add     t6, t4, t2		/* 㳰бɥ쥹 */
	lw      t7, (t6)		/* C롼θƽХɥ쥹 */
	jalr    t7			/* C롼ƤӽФ */
	mtc0    t5, Status		/* ߵ (EXLӥå = 0) */

	mfc0    t0, Status
	ori     t0, t0, SR_EXL
	mtc0    t0, Status              /* ߶ػ (EXLӥå = 1) */

	NOP_FOR_CP0_HAZARD		/* CP0ϥɤΤλֲԤޥ
					   (Υޥϥƥ¸) */

	j       join_interrupt_and_exception	/* 㳰ߤιή */
	nop

/* ߤξν */
proc_interrupt:

/*
 *  ߥȥ¿б뤿ᡢϥƥ¸ǹԤ
 *    ˡϡ
 *	ޥPROC_INTERRUPT_SYSˤޤϡؿƽ(proc_interrupt_sys)
 *    Ȥ롣
 *
 *  ƽл˥åȤƤ
 *	a1 : ơ쥸
 *	a2 : 쥸
 *
 *  ˤϡra쥸˲ƤϤʤʤ
 *
 *  Ūʽή졧
 *	1. װȽ
 *	2. ߥޥʥߥȥˤ
 *	3. ߵ
 *	4. ø롼θƽ
 *	5. ߶ػ
 *	6. ߥȥγ׵Υꥢ
 *     (7. join_interrupt_and_exception롣; ؿƽФξ)
 */

#ifdef PROC_INTERRUPT_SYS
	PROC_INTERRUPT_SYS
#else /* PROC_INTERRUPT_SYS */
	j	proc_interrupt_sys
	nop
#endif /* PROC_INTERRUPT_SYS */

/* 㳰߽ιή */
join_interrupt_and_exception:
	addi	k0, k0, -1		/* ͥȥ ǥ */
	lw      ra, (sp)		/* ra  */
	jr      ra			/* proc_interrupt_and_exeption θƽи
					    */
	addi    sp, sp, 4

/*
 *  ߥϥɥ/CPU㳰ϥɥи
 *
 *  褬ƥȤreqflgåȤƤΤߡˤ롣
 *  k0 = 0߶ػ߾֡ѥ쥸¸֤ǸƤӽФȡ
 *  t1runtskͤƤret_int_1˥פ뤳ȡ
 */

ret_int:
	POP_ICU_IPM			/* ߥȥγߥޥ
					   ޥ(ƥ¸) */

	lw      t1, 21*4(sp)		/* Status */
	ori	t1, t1, SR_EXL		/* ߽ȤΡCPUå
					   ֤ݻΤǡ߶ػߤ
					   EXLӥåȤѤƹԤ */
	mtc0    t1, Status		/* MIPS3γߥޥ
					    + EXLӥåȤˤ߶ػ */

	la      t0, enadsp
	la      t3, runtsk
	lw      t2, (t0)		/* t2 = enadsp */
	lw      t1, (t3)		/* t1 = runtsk */
 	beq     t2, zero, ret_int_1	/* ǥѥåػߤʤ饸 */
	nop
	la      t4, schedtsk
	lw      t5, (t4)		/* t5 = schedtsk */
	beq     t1, t5, ret_int_1	/* runtsk = schedtsk ʤ饸 */
	nop

/* ǥѥåͳν (t1 = runtsk ) */
	/* 顢߶ػߡĤEXLӥåȤѤƼ¸ˡѹ */
	mfc0	t0, Status
	ori	t0, t0, SR_EXL_IE
	xori	t0, t0, SR_EXL_IE	/* lock_cpu  (߶ػ)
					    + EXLӥåȥꥢ (ߵ) */
	mtc0	t0, Status

	addi    sp, sp, -8*4		/* å쥸¸ */
	sw      s0, 0*4(sp)
	sw      s1, 1*4(sp)
	sw      s2, 2*4(sp)
	sw      s3, 3*4(sp)
	sw      s4, 4*4(sp)
	sw      s5, 5*4(sp)
	sw      s6, 6*4(sp)
	sw      s7, 7*4(sp)
					/* t1 = runtsk   */
	sw      sp, TCB_sp(t1)		/* runtsk->sp = sp
					   (åݥ󥿤¸) */
	la      t2, ret_int_r

	j       dispatcher		/* ǥѥåƤӽФ */
	sw      t2, TCB_pc(t1)		/* runtsk->pc = ret_int_r
					   (¹ԺƳϤ¸) */

/*
 * ߡ㳰νи
 *   ǥѥåˤơt1 = runtsk ȤʤäƤ뤳Ȥ
 *   åݥ󥿤Ѥ
 */
/* ǥѥåƤӽФΥƥȤιή */
ret_int_r:
	lw      s0, 0*4(sp)		/* å쥸 */
	lw      s1, 1*4(sp)
	lw      s2, 2*4(sp)
	lw      s3, 3*4(sp)
 	lw      s4, 4*4(sp)
	lw      s5, 5*4(sp)
	lw      s6, 6*4(sp)
	lw      s7, 7*4(sp)
	addi    sp, sp, 8*4

	mfc0	t0, Status
	ori	t0, t0, SR_EXL_IE	/* unlock_cpu  (ߵ)
					    + EXLӥåȥå (߶ػ) */
	mtc0	t0, Status

/* ǥѥåͳʤιή (t1 = runtsk ) */
ret_int_1:

	/* 㳰׵Υå */
	lb      t2, TCB_enatex(t1)
	andi    t4, t2, TCB_enatex_mask /* t3 = runtsk->enatex  */
	beq     t4, zero, ret_int_2     /* 㳰ػߤλ */
	nop

	lw      t5, TCB_texptn(t1)      /* t5 = runtsk->texptn */
	beq     t5, zero, ret_int_2	/* 㳰׵᤬̵ */
	nop

	mfc0	t0, Status
	ori	t0, t0, SR_EXL_IE
	xori	t0, t0, SR_EXL_IE	/* lock_cpu (߶ػ)
					    + EXLӥåȥꥢ (ߵ) */
	mtc0	t0, Status

	jal     call_texrtn             /* 㳰롼(å
					   ¸)θƤӽФ */
	nop
		/* call_texrtn()(task.c)ǤϡºݤΥ㳰롼Ƥ
		   Фǡunlock_cpulock_cpuԤäƤΤǡ֤
		   ݻ롣 */

	mfc0	t0, Status
	ori	t0, t0, SR_EXL_IE	/* unlock_cpu  (ߵ)
					    + EXLӥåȥå (߶ػ) */
	mtc0	t0, Status
	/* ޤǤ߶ػߡĤEXLӥåȤѤƼ¸ˡ */

ret_int_2:
	/* 쥸 (Status쥸ϡѤ) */
	lw      t1, 22*4(sp)		/* EPC */
	mtc0    t1, EPC

	lw      t2, 23*4(sp)		/* HI */
	lw      t3, 24*4(sp)		/* LO */

	mthi    t2			/* 쥸 HI  */
	mtlo    t3			/* 쥸 LO  */

	lw      at,  1*4(sp)
	lw      v0,  2*4(sp)
	lw      v1,  3*4(sp)
	lw      a0,  4*4(sp)
	lw      a1,  5*4(sp)
	lw      a2,  6*4(sp)
	lw      a3,  7*4(sp)
	lw      t0,  8*4(sp)
	lw      t1,  9*4(sp)
	lw      t2, 10*4(sp)
	lw      t3, 11*4(sp)
	lw      t4, 12*4(sp)
	lw      t5, 13*4(sp)
	lw      t6, 14*4(sp)
	lw      t7, 15*4(sp)
	lw      t8, 16*4(sp)
	lw      t9, 17*4(sp)

	lw      gp, 18*4(sp)
	lw      fp, 19*4(sp)
	lw      ra, 20*4(sp)

	addi    sp, sp, 25*4

	eret				/* /㳰 */
	nop

/*
 *  ǥѥå
 *  dispatch ϡk0 = 0CPUå(߶ػ)֤ǸƤӽФʤФʤʤ
 *  exit_and_dispatch ϡk0 = 0CPUå(߶ػ)֤ǸƤӽФΤ§
 *    ͥ뵯ưΤᡤk0 = 1ǸƤӽФˤбƤ롣
 */

	.global dispatch
	.global exit_and_dispatch

/* ǥѥåŪ˸ƤӽФ */
dispatch:
	addi    sp, sp, -13*4
	sw      at,  1*4(sp)		/* å쥸 */
	sw      s0,  2*4(sp)
	sw      s1,  3*4(sp)
	sw      s2,  4*4(sp)
	sw      s3,  5*4(sp)
	sw      s4,  6*4(sp)
	sw      s5,  7*4(sp)
	sw      s6,  8*4(sp)
	sw      s7,  9*4(sp)
	sw      gp, 10*4(sp)
	sw      fp, 11*4(sp)
	sw      ra, 12*4(sp)

	la      t0, runtsk
	la      t2, dispatch_r
	lw      t1, (t0)		/* t1 = runtsk */
	sw      sp, TCB_sp(t1)		/* runtsk->sp = sp */
	j       dispatcher
	sw      t2, TCB_pc(t1)		/* runtsk->pc = dispatch_r */

/* ߼¹ΥƥȤΤƤơǥѥåƤӽФ */
exit_and_dispatch:
	move    k0, zero		/* ͥȥ󥿤򥯥ꥢ */

dispatcher:
	/* ˤ CPUåʳ߶ػߡˤ뤳 */
	la      t0, schedtsk
	lw      t1, (t0)		/* t1 = schedtsk */
	beq     t1, zero, dispatcher_2	/* schedtsk ̵гԤ */
	nop

dispatcher_1:
	la      t0, runtsk
	sw      t1, (t0)		/* runtsk = t1 (= schedtsk)
					   (åμ¹) */
	lw      t2, TCB_pc(t1)		/* ¹ԺƳϤ롣
					   ¹ԺƳϤϰʲ3̤
					     ǥѥåνи  dispatch_r
					     ߡ㳰νи    ret_int_r
					     ưľ        activate_r
					   ξ t1=runtsk ȤƸƤ
					   ФƤ뤳Ȥա */
	jr      t2			/* ¹ԺƳϤإ */
	lw      sp, TCB_sp(t1)		/* åݥ󥿤 */

	/*
	 *  ¹Ԥ٤ޤԤĽ
	 *
	 *  ǥƥȤڤ괹Τϡ
	 *    ȯ߽ˤɤΥåȤȤβ
	 *    ߥϥɥǤΥǥѥåɻ
	 *  ȤĤΰ̣롥
	 */ 
dispatcher_2:
	la	t2, runtsk
	sw	zero, (t2)		/* runtsk = NULL
					   ϡiget_id TSK_NONE֤
					   б뤿ᡣ*/

	la      sp, _stack_top		/* åڤؤ */
					/* _stack_top ϡƥ¸
					   (󥫥ץȿ侩) */
	li      k0, 1			/* ͥȥ󥿡1 */

	/* 롼ǻȤν */
	la      t2, reqflg              /* reqflg Υɥ쥹 */
	li      t3, ~SR_ERL_EXL         /* Status γߴϢӥå */
	li      t4, ~SR_IE              /* Status γߵĥӥå */

dispatcher_3:
	mfc0    t1, Status
	and     t1, t1, t3		/* ERL, EXL ӥåȥꥢ */
	ori     t1, t1, SR_IE		/* IEӥåȥå */
	mtc0    t1, Status		/* ߵ : unlock_cpu  */
	and     t1, t1, t4		/* IEӥåȥꥻå */
	mtc0    t1, Status		/* ߶ػ : lock_cpu  */

	NOP_FOR_CP0_HAZARD		/* CP0ϥɤΤλֲԤޥ
					   (Υޥϥƥ¸) */

	lw      t5, (t2)		/* t5 = reqflg */

	beq     t5, zero, dispatcher_3	/* ǥѥå׵᤬ʤХ롼פ
					   Ƭ */
	nop
	sw      zero, (t2)		/* reqflg = NULL (reqflg򥯥ꥢ) */
	j       dispatcher		/* ¹ԺƳϤμإ */
	move    k0, zero		/* ͥȥ󥿤򥯥ꥢ */

/*
 *  ǥѥåи
 *  ǥѥåˤơt1 = runtsk ȤʤäƤ뤳Ȥ
 *  åݥ󥿤Ѥ
 */
dispatch_r: 
	lw      at,  1*4(sp)		/* å쥸 */
	lw      s0,  2*4(sp)
	lw      s1,  3*4(sp)
	lw      s2,  4*4(sp)
	lw      s3,  5*4(sp)
	lw      s4,  6*4(sp)
	lw      s5,  7*4(sp)
	lw      s6,  8*4(sp)
	lw      s7,  9*4(sp)
	lw      gp, 10*4(sp)
	lw      fp, 11*4(sp)
	lw      ra, 12*4(sp)
	addi    sp, sp, 13*4

	/* 㳰׵Υå */
	lb      t2, TCB_enatex(t1)
	andi    t4, t2, TCB_enatex_mask	/* t4 = runtsk->enatex */
	beq     t4, zero, dispatch_r_1	/* 㳰ػߤλ */
	nop

	lw      t5, TCB_texptn(t1)	/* t5 = runtsk->texptn */
	beq     t5, zero, dispatch_r_1	/* 㳰׵᤬̵ */
	nop

	j       call_texrtn		/* 㳰롼(å
					   ¸)θƤӽФ */
	nop
		/* call_texrtn()(task.c)ǤϡºݤΥ㳰롼Ƥ
		   Фǡunlock_cpulock_cpuԤäƤΤǡ֤
		   ݻ롣 */

dispatch_r_1:
	jr      ra			/* dispatch ƤӽФ */
	nop

/*
 *  ư
 *  ǥѥåˤơt1 = runtsk ȤʤäƤ뤳Ȥ
 *  åݥ󥿤Ѥ
 */

	.globl activate_r

activate_r:
	/* ȤϡCPUåˤʤäƤIEӥå = 0) */

	/* ߵĤν */
	mfc0    t0, Status
	ori     t0, t0, SR_ERL_EXL_IE   /* xorȤᡢ1٥ӥåȥåȤ */
	xori    t0, t0, SR_ERL_EXL      /* ERL, EXLӥåȤ򥯥ꥢ
					   (IEӥåȤϻĤ)  */

	/* ط */
					/* t1 = runtsk (ǥѥå) */
	lw      t2, TCB_tinib(t1)       /* t2 = runtsk->tinib */

	/* ưϤ */
	lw      t3, TINIB_task(t2)      /* t3 = runtsk->tinib->task */

	/* ؤΰʳĥ */
	lw      a0, TINIB_exinf(t2)     /* a0 = runtsk->tinib->exinf */

	mtc0    t0, Status              /* unlock_cpu  (ߵ) */

	la      ra, ext_tsk             /* Ϥ */

	j       t3                      /* ư */
	nop
