/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.3 2005/07/06 01:48:21 honda Exp $
 */


/*
 *  ץå¸⥸塼NiosIIѡ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>


/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */


/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */

/*
 *  TCB ΥեɤΥӥå
 */
#define    TBIT_TCB_PRIORITY    8    /* priority եɤΥӥå */
#define    TBIT_TCB_TSTAT       8    /* tstat եɤΥӥå */


#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
        VP    sp;             /* åݥ */
        FP  pc;             /* ץ५ */
} CTXB;


/*
 * ߤΥͥȲΥ
 */
extern UW interrupt_count;

/*
 *  ƥֻ
 */
Inline BOOL
sense_context()
{
    return(interrupt_count > 0);    
}

Inline BOOL
sense_lock()
{
    return((current_status() & STATUS_PIE) == 0);
}

#define t_sense_lock    sense_lock
#define i_sense_lock    sense_lock


/*
 *  CPUåȤβ
 */
#define t_lock_cpu      lock_cpu
#define i_lock_cpu      lock_cpu
#define t_unlock_cpu    unlock_cpu
#define i_unlock_cpu    unlock_cpu

Inline void
lock_cpu()
{
    disint();
}

Inline void
unlock_cpu()
{
    enaint();
}


/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void    dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void    exit_and_dispatch(void);


/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  ߥϥɥ/ӥåȥޥΥơ֥
 *  int_handler_table[] ϳߥϥɥϿơ֥
 *  int_bit_table[]ϳߤ̤ͥ˱ӥåȤΥơ֥Ǥꡤ
 *  
 */
extern FP   int_handler_table[MAX_INT_NUM];
extern UW   int_bit_table[MAX_INT_NUM];

/*
 *  CPU㳰ϥɥεơ֥
 */
extern FP    exc_handler_table[];

/*
 *
 *  ߥϥɥ
 *
 *  ͥ inhno γߥϥɥεưϤ inthdr ꤹ롥
 *  ơ֥Ͽ
 *  
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{
    int_handler_table[inhno] = inthdr;
}

/*
 *   CPU㳰ϥɥ
 *   ٥ơ֥Ͽ
 */   
Inline void
define_exc(EXCNO excno, FP exchdr)
{
    exc_handler_table[excno] = exchdr;
}


/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 *  
 */


/*
 *  ߥϥɥνޥ
 */

#define INTHDR_ENTRY(inthdr)  extern void inthdr(void);

#define INT_ENTRY(inthdr) inthdr

/*
 *  CPU㳰ϥɥνޥ
 *
 */
#define    EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp);

#define    EXC_ENTRY(exchdr)     exchdr

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȽ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
    return(interrupt_count > 1); 
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
    return((*(UW*)p_excinf & STATUS_PIE) == 0);
}


/*
 *  ץå¸ν
 */
extern void    cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void    cpu_terminate(void);


/*
 * ̤Ͽγ/㳰ȯΥ
 */
extern void     no_reg_interrupt(void);
extern void     no_reg_exception(void);

#endif /* _MACRO_ONLY_ */

/*
 *  vxget_tim 򥵥ݡȤ뤫ɤ
 */
#define    SUPPORT_VXGET_TIM

/*                                                                             
 *  ꥢݡֹ˴ؤ      
 */
#define TNUM_PORT   1   /* ݡȤ륷ꥢݡȤο */
#define TNUM_SIOP   1   /* ݡȤ륷ꥢI/OݡȤο */

/*
 *  ƥॿ˴ؤ
 */
#define    LOGTASK_PORTID    1    /* ƥϤ륷ꥢݡֹ */


#endif /* _CPU_CONFIG_H_ */
