/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN    
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.2 2004/07/25 05:20:13 honda Exp $
 */

/*
 *  ꥢI/OǥХSIO˥ɥ饤СNios2 UARTѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#include <nios2.h>


/*
 *  ꥢI/Oγߥϥɥγֹ
 */
#define INHNO_SIO UART_INTLVL


/*
 *  SIOɥ饤Фν롼
 */
#define sio_initialize uart_initialize

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB  *siopcb;
    
    /*
     *  ǥХ¸Υץ
     */
    siopcb = uart_opn_por(siopid, exinf);

    /*
     * ߥȥγߵ
     */
    ena_int(UART_INTLVL);

    return(siopcb);
}


/*
 * ꥢI/OݡȤνλ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
    /*                                                                          
     *  ǥХ¸Υ                                            
     */
    uart_cls_por(siopcb);
  
    /*
     * ߤζػ
     */
    dis_int(UART_INTLVL);
}


/*                                                                             
 *  SIOγߥϥɥ                                                        
 */
#define sio_handler uart_isr

/*                                                                             
 *  ꥢI/OݡȤؤʸ                                              
 */
#define sio_snd_chr uart_snd_chr



/*
 *  ꥢI/OݡȤʸ
 */
#define sio_rcv_chr uart_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define sio_ena_cbr uart_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define sio_dis_cbr uart_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define sio_ierdy_snd   uart_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define sio_ierdy_rcv   uart_ierdy_rcv


#endif /* _MACRO_ONLY */
#endif /*  _HW_SERIAL_H_ */
